/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.type.soul;

import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.buuz135.industrialforegoingsouls.capabilities.SoulCapabilities;
import com.google.common.collect.AbstractIterator;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.ultramega.refinedtypes.type.soul.SoulResource;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class SoulCapabilityCache {
    private final BlockCapabilityCache<ISoulHandler, @NullableType Direction> cache;
    private final Level level;
    private final BlockPos pos;

    public SoulCapabilityCache(ServerLevel level, BlockPos pos, Direction direction) {
        this.cache = BlockCapabilityCache.create((BlockCapability)SoulCapabilities.BLOCK, (ServerLevel)level, (BlockPos)pos, (Object)direction);
        this.level = level;
        this.pos = pos;
    }

    public Optional<ISoulHandler> getCapability() {
        return Optional.ofNullable((ISoulHandler)this.cache.getCapability());
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Iterator<ResourceAmount> createAmountIterator() {
        return this.getCapability().map(handler -> new AbstractIterator<ResourceAmount>(this){
            private int index;

            @Nullable
            protected ResourceAmount computeNext() {
                if (this.index > handler.getSoulTanks()) {
                    return (ResourceAmount)this.endOfData();
                }
                while (this.index < handler.getSoulTanks()) {
                    int amount = handler.getSoulInTank(this.index);
                    if (amount > 0) {
                        ++this.index;
                        return new ResourceAmount((ResourceKey)SoulResource.createSoulResource(), (long)amount);
                    }
                    ++this.index;
                }
                return (ResourceAmount)this.endOfData();
            }
        }).orElse(Collections.emptyListIterator());
    }

    public Iterator<ResourceKey> createIterator() {
        return this.getCapability().map(handler -> new AbstractIterator<ResourceKey>(this){
            private int index;

            @Nullable
            protected ResourceKey computeNext() {
                if (this.index > handler.getSoulTanks()) {
                    return (ResourceKey)this.endOfData();
                }
                while (this.index < handler.getSoulTanks()) {
                    int amount = handler.getSoulInTank(this.index);
                    if (amount > 0) {
                        ++this.index;
                        return SoulResource.createSoulResource();
                    }
                    ++this.index;
                }
                return (ResourceKey)this.endOfData();
            }
        }).orElse(Collections.emptyListIterator());
    }
}

