/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.screen.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.screen.widget.LoadingSpinner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class LoadingSpinnerWidget
extends AbstractWidget {
    private final Supplier<Boolean> active;
    private final ItemStack stack;

    public LoadingSpinnerWidget(int x, int y, int width, int height, Component component, ItemStack stack, Supplier<Boolean> active) {
        super(x, y, width, height, component);
        this.active = active;
        this.stack = stack;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.active.get().booleanValue()) {
            PoseStack poseStack = guiGraphics.pose();
            int ticks = (int)Minecraft.getInstance().level.getGameTime() % 80;
            int rotateTickMax = 60;
            int throbTickMax = 20;
            int rotateTicks = ticks % rotateTickMax;
            int throbTicks = ticks % throbTickMax;
            float rotationDegrees = ((float)rotateTicks + partialTicks) * (360.0f / (float)rotateTickMax);
            float scale = 1.0f + (throbTicks >= throbTickMax / 2 ? (float)throbTickMax - ((float)throbTicks + partialTicks) : (float)throbTicks + partialTicks) * (2.0f / (float)throbTickMax);
            poseStack.pushPose();
            poseStack.translate((float)this.getX(), (float)this.getY(), 0.0f);
            poseStack.scale(scale, scale, 1.0f);
            poseStack.mulPose(new Quaternionf().rotateLocalZ(rotationDegrees));
            LoadingSpinner.drawItem(poseStack, this.stack, 0, true, null);
            poseStack.popPose();
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }
}

