/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.networking;

import com.davenonymous.pipegoggles.PipeGoggles;
import com.davenonymous.pipegoggles.datacomponents.PipeGoggleDataComponent;
import com.davenonymous.pipegoggles.setup.ModDataComponents;
import com.davenonymous.pipegoggles.setup.ModItems;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RemoveStackForColorPacket(DyeColor color) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RemoveStackForColorPacket> TYPE = new CustomPacketPayload.Type(PipeGoggles.resource("remove_stack_for_color"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveStackForColorPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)DyeColor.STREAM_CODEC, RemoveStackForColorPacket::color, RemoveStackForColorPacket::new);

    public static void handleOnServer(RemoveStackForColorPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ItemStack goggleStack = context.player().getItemInHand(InteractionHand.MAIN_HAND);
            if (goggleStack.isEmpty() || !goggleStack.is((Item)ModItems.PIPE_GOGGLE_ITEM.get())) {
                return;
            }
            if (goggleStack.has((DataComponentType)ModDataComponents.PIPEGOGGLES_COMPONENT.get())) {
                PipeGoggleDataComponent oldData = (PipeGoggleDataComponent)goggleStack.get((DataComponentType)ModDataComponents.PIPEGOGGLES_COMPONENT.get());
                PipeGoggleDataComponent newData = oldData.without(packet.color());
                goggleStack.set((DataComponentType)ModDataComponents.PIPEGOGGLES_COMPONENT.get(), (Object)newData);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

