/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui.widgets;

import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetWithChoiceValue;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class WidgetSpriteSelect<T>
extends WidgetWithChoiceValue<T> {
    Map<T, SpriteData> spriteMap;

    public WidgetSpriteSelect() {
        this.setHeight(16);
        this.setWidth(16);
        this.spriteMap = new HashMap<T, SpriteData>();
        this.addClickListener();
    }

    public void mapChoiceToSprite(T choice, SpriteData sprite) {
        this.spriteMap.put(choice, sprite);
    }

    public void addChoiceWithSprite(T choice, SpriteData sprite) {
        this.addChoice(choice);
        this.mapChoiceToSprite(choice, sprite);
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        SpriteData sprite = this.spriteMap.get(this.getValue());
        if (sprite == null) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.sprite);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = (this.width - sprite.width) / 2;
        int yOffset = (this.height - sprite.height) / 2;
        pGuiGraphics.blit(sprite.sprite, xOffset, yOffset, sprite.u, sprite.v, sprite.width, sprite.height);
    }

    public record SpriteData(ResourceLocation sprite, int u, int v, int width, int height) {
    }
}

