/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.datacomponents;

import com.davenonymous.pipegoggles.config.Rules;
import com.davenonymous.pipegoggles.data.EnergyCosts;
import com.davenonymous.pipegoggles.data.EnumGoggleMode;
import com.davenonymous.pipegoggles.data.GoggleSupport;
import com.davenonymous.pipegoggles.data.cache.GoggleSupportCache;
import com.davenonymous.pipegoggles.lib.BiggerStreamCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public record PipeGoggleDataComponent(Map<DyeColor, ItemStack> colors, List<DyeColor> enabledColors, float range, EnumGoggleMode goggleMode, long storedEnergy, int alpha, int lineWidth) {
    public static final Codec<PipeGoggleDataComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)DyeColor.CODEC, (Codec)ItemStack.CODEC).fieldOf("colors").forGetter(PipeGoggleDataComponent::colors), (App)DyeColor.CODEC.listOf().optionalFieldOf("enabled_colors", new ArrayList()).forGetter(PipeGoggleDataComponent::enabledColors), (App)Codec.FLOAT.optionalFieldOf("range", (Object)Float.valueOf(16.0f)).forGetter(PipeGoggleDataComponent::range), (App)EnumGoggleMode.CODEC.optionalFieldOf("mode", (Object)EnumGoggleMode.SMART).forGetter(PipeGoggleDataComponent::goggleMode), (App)Codec.LONG.optionalFieldOf("energy", (Object)0L).forGetter(PipeGoggleDataComponent::storedEnergy), (App)Codec.INT.optionalFieldOf("alpha", (Object)255).forGetter(PipeGoggleDataComponent::alpha), (App)Codec.INT.optionalFieldOf("line_width", (Object)2).forGetter(PipeGoggleDataComponent::lineWidth)).apply((Applicative)instance, PipeGoggleDataComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PipeGoggleDataComponent> STREAM_CODEC = BiggerStreamCodec.composite(ByteBufCodecs.map(HashMap::new, (StreamCodec)DyeColor.STREAM_CODEC, (StreamCodec)ItemStack.STREAM_CODEC, (int)16), PipeGoggleDataComponent::colors, DyeColor.STREAM_CODEC.apply(ByteBufCodecs.list((int)16)), PipeGoggleDataComponent::enabledColors, ByteBufCodecs.FLOAT, PipeGoggleDataComponent::range, EnumGoggleMode.STREAM_CODEC, PipeGoggleDataComponent::goggleMode, ByteBufCodecs.VAR_LONG, PipeGoggleDataComponent::storedEnergy, ByteBufCodecs.INT, PipeGoggleDataComponent::alpha, ByteBufCodecs.INT, PipeGoggleDataComponent::lineWidth, PipeGoggleDataComponent::new);

    public PipeGoggleDataComponent() {
        this(new HashMap<DyeColor, ItemStack>(), new ArrayList<DyeColor>(), 8.0f, EnumGoggleMode.SMART, 0L, 255, 2);
    }

    public PipeGoggleDataComponent(Map<DyeColor, ItemStack> colors) {
        this(new HashMap<DyeColor, ItemStack>(colors), new ArrayList<DyeColor>(), 8.0f, EnumGoggleMode.SMART, 0L, 255, 2);
    }

    public PipeGoggleDataComponent with(DyeColor color, ItemStack stack) {
        HashMap<DyeColor, ItemStack> newColors = new HashMap<DyeColor, ItemStack>(this.colors);
        newColors.put(color, stack);
        ArrayList<DyeColor> newEnabledColors = new ArrayList<DyeColor>(this.enabledColors);
        if (!newEnabledColors.contains(color)) {
            newEnabledColors.add(color);
        }
        return new PipeGoggleDataComponent(newColors, newEnabledColors, this.range, this.goggleMode, this.storedEnergy, this.alpha, this.lineWidth);
    }

    public PipeGoggleDataComponent withRange(float range) {
        return new PipeGoggleDataComponent(new HashMap<DyeColor, ItemStack>(this.colors), this.enabledColors, range, this.goggleMode, this.storedEnergy, this.alpha, this.lineWidth);
    }

    public PipeGoggleDataComponent without(DyeColor color) {
        HashMap<DyeColor, ItemStack> newColors = new HashMap<DyeColor, ItemStack>(this.colors);
        newColors.remove(color);
        ArrayList<DyeColor> newEnabledColors = new ArrayList<DyeColor>(this.enabledColors);
        newEnabledColors.remove(color);
        return new PipeGoggleDataComponent(newColors, newEnabledColors, this.range, this.goggleMode, this.storedEnergy, this.alpha, this.lineWidth);
    }

    public PipeGoggleDataComponent disable(DyeColor color) {
        ArrayList<DyeColor> newEnabledColors = new ArrayList<DyeColor>(this.enabledColors);
        newEnabledColors.remove(color);
        return new PipeGoggleDataComponent(new HashMap<DyeColor, ItemStack>(this.colors), newEnabledColors, this.range, this.goggleMode, this.storedEnergy, this.alpha, this.lineWidth);
    }

    public PipeGoggleDataComponent enable(DyeColor color) {
        ArrayList<DyeColor> newEnabledColors = new ArrayList<DyeColor>(this.enabledColors);
        if (!newEnabledColors.contains(color)) {
            newEnabledColors.add(color);
        }
        return new PipeGoggleDataComponent(new HashMap<DyeColor, ItemStack>(this.colors), newEnabledColors, this.range, this.goggleMode, this.storedEnergy, this.alpha, this.lineWidth);
    }

    public PipeGoggleDataComponent withColorEnabled(DyeColor color, boolean enabled) {
        return enabled ? this.enable(color) : this.disable(color);
    }

    public PipeGoggleDataComponent withMode(EnumGoggleMode enabled) {
        return new PipeGoggleDataComponent(new HashMap<DyeColor, ItemStack>(this.colors), new ArrayList<DyeColor>(this.enabledColors), this.range, enabled, this.storedEnergy, this.alpha, this.lineWidth);
    }

    public PipeGoggleDataComponent withStoredEnergy(long energy) {
        return new PipeGoggleDataComponent(new HashMap<DyeColor, ItemStack>(this.colors), new ArrayList<DyeColor>(this.enabledColors), this.range, this.goggleMode, energy, this.alpha, this.lineWidth);
    }

    public PipeGoggleDataComponent withAlpha(int alpha) {
        return new PipeGoggleDataComponent(new HashMap<DyeColor, ItemStack>(this.colors), new ArrayList<DyeColor>(this.enabledColors), this.range, this.goggleMode, this.storedEnergy, alpha, this.lineWidth);
    }

    public PipeGoggleDataComponent withLineWidth(int lineWidth) {
        return new PipeGoggleDataComponent(new HashMap<DyeColor, ItemStack>(this.colors), new ArrayList<DyeColor>(this.enabledColors), this.range, this.goggleMode, this.storedEnergy, this.alpha, lineWidth);
    }

    public boolean isEnabled() {
        return this.goggleMode != EnumGoggleMode.OFF;
    }

    public boolean isSmartMode() {
        return this.goggleMode == EnumGoggleMode.SMART;
    }

    public boolean isDisabled() {
        return this.goggleMode == EnumGoggleMode.OFF;
    }

    public boolean isColorEnabled(DyeColor color) {
        return this.colors.containsKey(color) && this.enabledColors.contains(color);
    }

    public boolean enoughEnergy() {
        return !Rules.requireEnergy || this.storedEnergy >= EnergyCosts.getCost(this);
    }

    public Optional<GoggleSupport> getSupportForColor(DyeColor color) {
        ItemStack stack = this.colors.get(color);
        if (stack == null || stack.isEmpty()) {
            return Optional.empty();
        }
        Optional<GoggleSupport> optSupport = GoggleSupportCache.getSupportFor(stack);
        if (optSupport.isEmpty()) {
            return Optional.empty();
        }
        return optSupport;
    }

    public Optional<GoggleSupport> getColorForTrigger(ItemStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        for (DyeColor color : this.colors.keySet()) {
            Optional<GoggleSupport> support = this.getSupportForColor(color);
            if (!support.isPresent() || !support.get().isTriggerItem(stack)) continue;
            return support;
        }
        return Optional.empty();
    }

    public Optional<DyeColor> getColorForStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        for (DyeColor color : this.colors.keySet()) {
            Optional<GoggleSupport> support = this.getSupportForColor(color);
            if (!support.isPresent() || !support.get().isTriggerItem(stack)) continue;
            return Optional.of(color);
        }
        return Optional.empty();
    }

    public String modIdForBlock(Block block) {
        if (block == null || !block.builtInRegistryHolder().isBound()) {
            return "minecraft";
        }
        return block.builtInRegistryHolder().getKey().location().getNamespace();
    }

    public String modIdForStack(ItemStack stack) {
        if (stack.isEmpty() || !stack.getItem().builtInRegistryHolder().isBound()) {
            return "minecraft";
        }
        return stack.getItem().builtInRegistryHolder().getKey().location().getNamespace();
    }

    public Optional<DyeColor> getColorForBlock(Block block) {
        String modId = this.modIdForBlock(block);
        return this.colors.entrySet().stream().filter(entry -> this.modIdForStack((ItemStack)entry.getValue()).equals(modId)).map(Map.Entry::getKey).findFirst();
    }

    public Optional<String> getModIdForColor(DyeColor color) {
        ItemStack stack = this.colors.get(color);
        if (stack == null || stack.isEmpty()) {
            return Optional.empty();
        }
        if (!stack.getItem().builtInRegistryHolder().isBound()) {
            return Optional.empty();
        }
        return Optional.of(stack.getItem().builtInRegistryHolder().getKey().location().getNamespace());
    }

    public Optional<ItemStack> getStackForColor(DyeColor color) {
        return Optional.ofNullable(this.colors.get(color));
    }

    public boolean colorsMatch(Map<DyeColor, ItemStack> otherColors) {
        if (this.colors.size() != otherColors.size()) {
            return false;
        }
        for (Map.Entry<DyeColor, ItemStack> entry : this.colors.entrySet()) {
            ItemStack otherStack = otherColors.get(entry.getKey());
            if (otherStack == null && entry.getValue() == null) {
                return true;
            }
            if (otherStack == null || entry.getValue() == null) {
                return false;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)entry.getValue(), (ItemStack)otherStack)) continue;
            return false;
        }
        return true;
    }

    public boolean enabledMatch(List<DyeColor> otherEnabledColors) {
        if (this.enabledColors.size() != otherEnabledColors.size()) {
            return false;
        }
        for (DyeColor color : this.enabledColors) {
            if (otherEnabledColors.contains(color)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        int n;
        long l;
        EnumGoggleMode enumGoggleMode;
        float f;
        Map<DyeColor, ItemStack> otherColors;
        Object object;
        if (!(o instanceof PipeGoggleDataComponent)) return false;
        PipeGoggleDataComponent pipeGoggleDataComponent = (PipeGoggleDataComponent)o;
        try {
            object = pipeGoggleDataComponent.colors();
            otherColors = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object otherEnabledColors = object = pipeGoggleDataComponent.enabledColors();
        float otherRange = f = pipeGoggleDataComponent.range();
        EnumGoggleMode otherMode = enumGoggleMode = pipeGoggleDataComponent.goggleMode();
        long otherEnergy = l = pipeGoggleDataComponent.storedEnergy();
        int otherAlpha = n = pipeGoggleDataComponent.alpha();
        int otherLineWidth = n = pipeGoggleDataComponent.lineWidth();
        if (Float.compare(this.range(), otherRange) != 0) return false;
        if (this.goggleMode() != otherMode) return false;
        if (this.storedEnergy() != otherEnergy) return false;
        if (this.alpha() != otherAlpha) return false;
        if (this.lineWidth() != otherLineWidth) return false;
        if (!this.enabledMatch((List<DyeColor>)otherEnabledColors)) return false;
        if (!this.colorsMatch(otherColors)) return false;
        return true;
    }

    private int hashColors() {
        return this.colors.entrySet().stream().map(entry -> Objects.hash(entry.getKey(), ItemStack.hashItemAndComponents((ItemStack)((ItemStack)entry.getValue())))).reduce(0, Integer::sum);
    }

    private int hashEnabledColors() {
        return this.enabledColors.stream().map(Enum::ordinal).map(i -> i * 31 + i).reduce(0, Integer::sum);
    }

    @Override
    public int hashCode() {
        int hash = Objects.hash(new Object[]{this.hashColors(), this.hashEnabledColors(), Float.valueOf(this.range()), this.goggleMode(), this.storedEnergy(), this.alpha(), this.lineWidth()});
        return hash;
    }
}

