/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.data;

import com.davenonymous.pipegoggles.config.Rules;
import com.davenonymous.pipegoggles.datacomponents.PipeGoggleDataComponent;
import com.davenonymous.pipegoggles.setup.ModDataComponents;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.EnergyStorage;

public class GoggleEnergyStorage
extends EnergyStorage {
    ItemStack stack;

    public GoggleEnergyStorage(ItemStack stack) {
        super(Rules.maxEnergy);
        this.stack = stack;
        this.maxReceive = Rules.maxEnergyReceive;
        this.maxExtract = 0;
        PipeGoggleDataComponent goggleData = (PipeGoggleDataComponent)stack.getOrDefault(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)new PipeGoggleDataComponent());
        if (goggleData.storedEnergy() > 0L) {
            this.energy = (int)goggleData.storedEnergy();
        }
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, toReceive));
        if (!simulate) {
            this.energy += energyReceived;
            PipeGoggleDataComponent goggleData = (PipeGoggleDataComponent)this.stack.getOrDefault(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)new PipeGoggleDataComponent());
            PipeGoggleDataComponent newData = goggleData.withStoredEnergy(this.energy);
            this.stack.set(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)newData);
        }
        return energyReceived;
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, toExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            PipeGoggleDataComponent goggleData = (PipeGoggleDataComponent)this.stack.getOrDefault(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)new PipeGoggleDataComponent());
            PipeGoggleDataComponent newData = goggleData.withStoredEnergy(this.energy);
            this.stack.set(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)newData);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        if (!Rules.requireEnergy) {
            return this.capacity;
        }
        PipeGoggleDataComponent goggleData = (PipeGoggleDataComponent)this.stack.getOrDefault(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)new PipeGoggleDataComponent());
        return (int)goggleData.storedEnergy();
    }
}

