/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.gui.buttons;

import com.heaser.pipeconnector.client.gui.buttons.BaseButton;
import com.heaser.pipeconnector.network.UpdateInventoryGuard;
import com.heaser.pipeconnector.utils.TagUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class InventoryGuardButton
extends BaseButton {
    public InventoryGuardButton(ItemStack itemStack) {
        super(InventoryGuardButton.getInitialLabel(itemStack), 20, 20);
    }

    @Override
    public void onClick(Button clickedButton, ItemStack itemStack) {
        if (TagUtils.getPreventInventoryBlockBreaking(itemStack)) {
            this.setLabel("item.pipe_connector.gui.button.off", ChatFormatting.RED);
            this.button.setMessage(this.getLabel());
            TagUtils.setInventoryGuard(itemStack, false);
        } else {
            this.setLabel("item.pipe_connector.gui.button.on", ChatFormatting.GREEN);
            this.button.setMessage(this.getLabel());
            TagUtils.setInventoryGuard(itemStack, true);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateInventoryGuard(TagUtils.getPreventInventoryBlockBreaking(itemStack)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public Component getTooltip(ItemStack itemStack) {
        return Component.translatable((String)"item.pipe_connector.gui.button.tooltip.InventoryGuard");
    }

    private static Component getInitialLabel(ItemStack itemStack) {
        if (TagUtils.getPreventInventoryBlockBreaking(itemStack)) {
            return Component.translatable((String)"item.pipe_connector.gui.button.on").withStyle(ChatFormatting.GREEN);
        }
        return Component.translatable((String)"item.pipe_connector.gui.button.off").withStyle(ChatFormatting.RED);
    }
}

