/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.gui;

import com.heaser.pipeconnector.client.gui.buttons.AvoidInventoryBlocksButton;
import com.heaser.pipeconnector.client.gui.buttons.BaseButton;
import com.heaser.pipeconnector.client.gui.buttons.BridgeTypeButton;
import com.heaser.pipeconnector.client.gui.buttons.BuildPipesButton;
import com.heaser.pipeconnector.client.gui.buttons.InventoryGuardButton;
import com.heaser.pipeconnector.client.gui.buttons.OutlinePreviewButton;
import com.heaser.pipeconnector.client.gui.buttons.ResetButton;
import com.heaser.pipeconnector.client.gui.buttons.SolidPreviewButton;
import com.heaser.pipeconnector.client.gui.buttons.UtilizeExistingPipesButton;
import com.heaser.pipeconnector.client.gui.interfaces.ILabelable;
import com.heaser.pipeconnector.client.gui.labels.AvoidInventoryBlocksText;
import com.heaser.pipeconnector.client.gui.labels.DepthLabel;
import com.heaser.pipeconnector.client.gui.labels.InventoryGuardText;
import com.heaser.pipeconnector.client.gui.labels.PreviewStyleText;
import com.heaser.pipeconnector.client.gui.labels.TitleLabelText;
import com.heaser.pipeconnector.client.gui.labels.UtilizeExistingPipesText;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class PipeConnectorGui
extends Screen {
    public static final ResourceLocation PIPE_CONNECTOR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"pipe_connector", (String)"textures/gui/settings.png");
    protected static final Integer imageWidth = 256;
    protected static final Integer imageHeight = 256;
    private ItemStack pipeConnectorStack;
    private BaseButton resetBaseButton;
    private BaseButton buildPipesButton;
    private BaseButton bridgeTypeButton;
    private BaseButton utilizeExistingPipesButton;
    private BaseButton inventoryGuardButton;
    private BaseButton avoidInventoryBlocksButton;
    private BaseButton outlinePreviewButton;
    private BaseButton solidPreviewButton;

    public PipeConnectorGui(ItemStack pipeConnectorStack) {
        super((Component)Component.literal((String)"PipeConnectorScreen"));
        this.pipeConnectorStack = pipeConnectorStack;
    }

    protected void init() {
        this.bridgeTypeButton = this.createButton(0.05, 0.2, new BridgeTypeButton(this.pipeConnectorStack));
        this.inventoryGuardButton = this.createButton(0.45, 0.3, new InventoryGuardButton(this.pipeConnectorStack));
        this.avoidInventoryBlocksButton = this.createButton(0.45, 0.4, new AvoidInventoryBlocksButton(this.pipeConnectorStack));
        this.utilizeExistingPipesButton = this.createButton(0.45, 0.5, new UtilizeExistingPipesButton(this.pipeConnectorStack));
        this.outlinePreviewButton = this.createButton(0.6, 0.5, new OutlinePreviewButton(this.pipeConnectorStack));
        this.solidPreviewButton = this.createButton(0.78, 0.5, new SolidPreviewButton(this.pipeConnectorStack));
        this.resetBaseButton = this.createButton(0.62, 0.7, new ResetButton());
        this.buildPipesButton = this.createButton(0.6, 0.8, new BuildPipesButton(this.getMinecraft().player));
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.getMinecraft().player != null && GeneralUtils.isHoldingPipeConnector((Player)this.getMinecraft().player)) {
            this.pipeConnectorStack = this.getMinecraft().player.getMainHandItem();
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PIPE_CONNECTOR_TEXTURE);
        int drawStartX = this.getScreenX();
        int drawStartY = this.getScreenY();
        this.drawTooltip(guiGraphics, mouseX, mouseY, this.resetBaseButton);
        this.drawTooltip(guiGraphics, mouseX, mouseY, this.buildPipesButton);
        this.drawTooltipList(guiGraphics, mouseX, mouseY, this.bridgeTypeButton);
        this.drawTooltip(guiGraphics, mouseX, mouseY, this.inventoryGuardButton);
        this.drawTooltipList(guiGraphics, mouseX, mouseY, this.utilizeExistingPipesButton);
        this.drawTooltipList(guiGraphics, mouseX, mouseY, this.avoidInventoryBlocksButton);
        guiGraphics.blit(PIPE_CONNECTOR_TEXTURE, drawStartX, drawStartY, 0, 0, imageWidth.intValue(), imageHeight.intValue());
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.utilizeExistingPipesButton.button.active = this.utilizeExistingPipesButton.isActive(this.pipeConnectorStack);
        this.avoidInventoryBlocksButton.button.active = this.avoidInventoryBlocksButton.isActive(this.pipeConnectorStack);
        this.buildPipesButton.button.active = this.buildPipesButton.isActive(this.pipeConnectorStack);
        BaseButton baseButton = this.outlinePreviewButton;
        if (baseButton instanceof OutlinePreviewButton) {
            OutlinePreviewButton opb = (OutlinePreviewButton)baseButton;
            opb.updateLabel(this.pipeConnectorStack);
        }
        if ((baseButton = this.solidPreviewButton) instanceof SolidPreviewButton) {
            SolidPreviewButton spb = (SolidPreviewButton)baseButton;
            spb.updateLabel(this.pipeConnectorStack);
        }
        this.createLabel(guiGraphics, 0.07, 0.05, new TitleLabelText(), 3.0f);
        this.createLabel(guiGraphics, 0.12, 0.32, new InventoryGuardText());
        this.createLabel(guiGraphics, 0.08, 0.42, new AvoidInventoryBlocksText());
        this.createLabel(guiGraphics, 0.08, 0.52, new UtilizeExistingPipesText());
        this.createLabel(guiGraphics, 0.6, 0.45, new PreviewStyleText());
        this.createLabel(guiGraphics, 0.62, 0.65, new DepthLabel());
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.minecraft.level == null) {
            this.renderPanorama(pGuiGraphics, pPartialTick);
        }
        this.renderMenuBackground(pGuiGraphics);
        NeoForge.EVENT_BUS.post((Event)new ScreenEvent.Render.Post((Screen)this, pGuiGraphics, pMouseX, pMouseY, pPartialTick));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.shouldCloseOnEsc() || keyCode == 69) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private BaseButton createButton(double marginXPercent, double marginYPercent, BaseButton baseButton) {
        int marginX = (int)((double)imageWidth.intValue() * marginXPercent);
        int marginY = (int)((double)imageHeight.intValue() * marginYPercent);
        int drawStartX = this.getScreenX() + marginX;
        int drawStartY = this.getScreenY() + marginY;
        Button button = Button.builder((Component)baseButton.label, clickedButton -> this.onButtonClick(clickedButton, baseButton)).pos(drawStartX, drawStartY).size(baseButton.getButtonWidth(), baseButton.getButtonHeight()).build();
        button.active = baseButton.isActive(this.pipeConnectorStack);
        baseButton.bindButton(button);
        this.addRenderableWidget((GuiEventListener)button);
        return baseButton;
    }

    private void createLabel(GuiGraphics guiGraphics, double marginXPercent, double marginYPercent, ILabelable label) {
        int marginX = (int)((double)imageWidth.intValue() * marginXPercent);
        int marginY = (int)((double)imageHeight.intValue() * marginYPercent);
        int drawStartX = this.getScreenX() + marginX;
        int drawStartY = this.getScreenY() + marginY;
        guiGraphics.drawString(this.font, label.getLabel(this.pipeConnectorStack), drawStartX, drawStartY, 0, false);
    }

    private void createLabel(GuiGraphics guiGraphics, double marginXPercent, double marginYPercent, ILabelable label, float scale) {
        int marginX = (int)((double)imageWidth.intValue() * marginXPercent);
        int marginY = (int)((double)imageHeight.intValue() * marginYPercent);
        int drawStartX = (this.getScreenX() + marginX) / (int)scale;
        int drawStartY = (this.getScreenY() + marginY) / (int)scale;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, scale);
        guiGraphics.drawString(this.font, label.getLabel(this.pipeConnectorStack), drawStartX, drawStartY, 0, false);
        guiGraphics.pose().popPose();
    }

    private void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, BaseButton baseButton) {
        Component tooltipText = baseButton.getTooltip(this.pipeConnectorStack);
        if (tooltipText != null && baseButton.button.isHovered()) {
            guiGraphics.renderTooltip(this.font, tooltipText, mouseX, mouseY);
        }
    }

    private void drawTooltipList(GuiGraphics guiGraphics, int mouseX, int mouseY, BaseButton baseButton) {
        List<Component> tooltipTextList = baseButton.getTooltipList(this.pipeConnectorStack);
        if (tooltipTextList != null && baseButton.button.isHovered()) {
            guiGraphics.renderTooltip(this.font, tooltipTextList, Optional.empty(), mouseX, mouseY);
        }
    }

    private void onButtonClick(Button clickedButton, BaseButton baseButton) {
        baseButton.onClick(clickedButton, this.pipeConnectorStack);
        if (baseButton.shouldClose()) {
            this.onClose();
        }
    }

    private int getScreenX() {
        return (this.width - imageWidth) / 2;
    }

    private int getScreenY() {
        return (this.height - imageHeight) / 2;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

