/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Positioning;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.blocks.addons.CombiAddonBlock;
import rearth.oritech.block.entity.interaction.ShrinkerBlockEntity;
import rearth.oritech.client.ui.UpgradableMachineScreen;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.util.MachineAddonController;

public class ShrinkerScreen
extends UpgradableMachineScreen<UpgradableMachineScreenHandler> {
    public LabelComponent statusLabel;

    public ShrinkerScreen(UpgradableMachineScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        ButtonComponent shrinkButton = Components.button((Component)Component.translatable((String)"text.oritech.shrink"), event -> this.onShrinkPressed());
        shrinkButton.renderer(ORITECH_BUTTON_DARK);
        shrinkButton.textShadow(false);
        if (((UpgradableMachineScreenHandler)this.menu).addonController.getConnectedAddons().isEmpty()) {
            shrinkButton.active(false);
        }
        this.statusLabel = Components.label((Component)Component.translatable((String)"text.oritech.shrink_ready"));
        MachineAddonController machineAddonController = ((UpgradableMachineScreenHandler)this.menu).addonController;
        if (machineAddonController instanceof ShrinkerBlockEntity) {
            ShrinkerBlockEntity shrinkerBlockEntity = (ShrinkerBlockEntity)machineAddonController;
            if (shrinkerBlockEntity.currentCandidate != null) {
                ArrayList<Component> previewText = CombiAddonBlock.getShrinkTooltip(shrinkerBlockEntity.currentCandidate);
                previewText.add(0, (Component)Component.translatable((String)"tooltip.oritech.shrinker_action"));
                shrinkButton.tooltip(previewText);
            }
        }
        overlay.child(shrinkButton.positioning(Positioning.absolute((int)74, (int)38)));
        overlay.child((io.wispforest.owo.ui.core.Component)this.statusLabel.positioning(Positioning.absolute((int)40, (int)22)));
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (((UpgradableMachineScreenHandler)this.menu).addonController.getConnectedAddons().isEmpty()) {
            this.statusLabel.text((Component)Component.translatable((String)"text.oritech.shrink_no_addon").withStyle(ChatFormatting.RED));
        } else {
            ShrinkerBlockEntity shrinker;
            MachineAddonController machineAddonController = ((UpgradableMachineScreenHandler)this.menu).addonController;
            if (machineAddonController instanceof ShrinkerBlockEntity && (shrinker = (ShrinkerBlockEntity)machineAddonController).getEnergyStorage(null).getAmount() < shrinker.getDefaultCapacity()) {
                this.statusLabel.text((Component)Component.translatable((String)"text.oritech.shrink_no_energy").withStyle(ChatFormatting.RED));
            } else {
                this.statusLabel.text((Component)Component.translatable((String)"text.oritech.shrink_ready"));
            }
        }
    }

    private void onShrinkPressed() {
        NetworkManager.sendToServer(new ShrinkerBlockEntity.ShrinkerPlayerUsePacket(((UpgradableMachineScreenHandler)this.menu).getBlockPos()));
    }
}

