/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.storage;

import dev.architectury.fluid.FluidStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.blocks.storage.SmallFluidTank;
import rearth.oritech.block.entity.storage.SmallTankEntity;
import rearth.oritech.util.TooltipHelper;

public class CreativeFluidTank
extends SmallFluidTank {
    public CreativeFluidTank(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        TooltipHelper.addMachineTooltip(tooltip, this, this);
        if (Screen.hasControlDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.creative_tank").withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SmallTankEntity(pos, state, true);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        Item item;
        BlockEntity blockEntity;
        if (world.isClientSide || !((blockEntity = world.getBlockEntity(pos)) instanceof SmallTankEntity)) {
            return super.useWithoutItem(state, world, pos, player, hit);
        }
        SmallTankEntity blockEntity2 = (SmallTankEntity)blockEntity;
        ItemStack mainHandStack = player.getMainHandItem();
        if (mainHandStack.is(Items.BUCKET)) {
            blockEntity2.fluidStorage.setStack(FluidStack.empty());
            blockEntity2.setChanged();
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        if (!mainHandStack.isEmpty() && (item = mainHandStack.getItem()) instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            blockEntity2.fluidStorage.setStack(FluidStack.create((Fluid)bucketItem.arch$getFluid(), (long)1000L));
            blockEntity2.setChanged();
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }
}

