/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.mixin;

import com.omnitools.omniTools.core.ModItems;
import com.omnitools.omniTools.core.OmniToolItem;
import com.omnitools.omniTools.core.ToolMode;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Inject(method={"is(Lnet/minecraft/tags/TagKey;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void omnitools$hideWrenchTags(TagKey<Item> tag, CallbackInfoReturnable<Boolean> cir) {
        ItemStack self = (ItemStack)this;
        if (self.isEmpty()) {
            return;
        }
        if (self.getItem() != ModItems.OMNI_WRENCH.get()) {
            return;
        }
        if (!ItemStackMixin.omnitools$isWrenchTag(tag)) {
            return;
        }
        ToolMode mode = OmniToolItem.getMode(self);
        if (mode == ToolMode.LINK || mode == ToolMode.RENAME) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private static boolean omnitools$isWrenchTag(TagKey<Item> tag) {
        ResourceLocation id = tag.location();
        if ("tools/wrench".equals(id.getPath())) {
            return true;
        }
        return "mekanism".equals(id.getNamespace()) && "configurators".equals(id.getPath());
    }
}

