/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.block.SpiritFireBlock;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.common.item.spirit.BookOfBindingItem;
import com.klikli_dev.occultism.common.item.tool.SoulGemItem;
import com.klikli_dev.occultism.crafting.recipe.BoundBookOfBindingRecipe;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="occultism")
public class PlayerEventHandler {
    private static final ItemAbility LIGHT_FIRE = ItemAbility.get((String)"light_fire");
    private static final ItemAbility LIGHT_CAMPFIRE = ItemAbility.get((String)"light_campfire");

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEventHandler.spiritFire(event);
        PlayerEventHandler.dancingFamiliars(event);
        PlayerEventHandler.bookshelfBinding(event);
    }

    private static void spiritFire(PlayerInteractEvent.RightClickBlock event) {
        boolean canLightFire;
        boolean isFlintAndSteel = event.getItemStack().getItem() == Items.FLINT_AND_STEEL;
        boolean isFireCharge = event.getItemStack().getItem() == Items.FIRE_CHARGE;
        boolean bl = canLightFire = event.getItemStack().canPerformAction(LIGHT_FIRE) || event.getItemStack().canPerformAction(LIGHT_CAMPFIRE);
        if (isFlintAndSteel || isFireCharge || canLightFire) {
            AABB box = new AABB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0).move(Math3DUtil.center(event.getPos()));
            List list = event.getLevel().getEntitiesOfClass(ItemEntity.class, box, item -> item.getItem().is(OccultismTags.Items.START_SPIRIT_FIRE));
            if (!list.isEmpty()) {
                BlockPos pos;
                Level level = event.getLevel();
                BlockPos blockPos = pos = level.getBlockState(event.getPos()).canBeReplaced() ? event.getPos() : event.getPos().relative(event.getFace());
                if (!event.getEntity().mayUseItemAt(pos, event.getFace(), event.getItemStack())) {
                    return;
                }
                list.forEach(e -> e.remove(Entity.RemovalReason.DISCARDED));
                if (level.getBlockState(pos).canBeReplaced()) {
                    SoundEvent soundEvent = isFlintAndSteel ? SoundEvents.FLINTANDSTEEL_USE : SoundEvents.FIRECHARGE_USE;
                    level.playSound(event.getEntity(), pos, soundEvent, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.4f + 0.8f);
                    level.setBlock(pos, ((SpiritFireBlock)((Object)OccultismBlocks.SPIRIT_FIRE.get())).defaultBlockState(), 11);
                    if (isFlintAndSteel) {
                        event.getItemStack().hurtAndBreak(1, (LivingEntity)event.getEntity(), LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                    } else if (isFireCharge) {
                        event.getItemStack().shrink(1);
                    }
                }
                event.setCanceled(true);
                event.getEntity().swing(InteractionHand.MAIN_HAND);
            }
        }
    }

    private static void dancingFamiliars(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (!state.hasProperty((Property)JukeboxBlock.HAS_RECORD) || ((Boolean)state.getValue((Property)JukeboxBlock.HAS_RECORD)).booleanValue() || !event.getItemStack().has(DataComponents.JUKEBOX_PLAYABLE)) {
            return;
        }
        if (event.getLevel().getEntitiesOfClass(Entity.class, new AABB(event.getPos()).inflate(3.0), e -> e instanceof IFamiliar && ((IFamiliar)e).getFamiliarOwner() == event.getEntity()).isEmpty()) {
            return;
        }
        ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger((LivingEntity)event.getEntity(), FamiliarTrigger.Type.PARTY);
    }

    private static void bookshelfBinding(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != InteractionHand.MAIN_HAND || event.getItemStack().getItem() != OccultismItems.DICTIONARY_OF_SPIRITS.get() || !event.getEntity().isCrouching()) {
            return;
        }
        BlockEntity blockEntity = event.getLevel().getBlockEntity(event.getPos());
        if (!(blockEntity instanceof ChiseledBookShelfBlockEntity)) {
            return;
        }
        ChiseledBookShelfBlockEntity bookShelf = (ChiseledBookShelfBlockEntity)blockEntity;
        for (int i = 0; i < 6; ++i) {
            Item item = bookShelf.getItem(i).getItem();
            if (!(item instanceof BookOfBindingItem)) continue;
            BookOfBindingItem book = (BookOfBindingItem)item;
            if (((Object)((Object)book)).equals(OccultismItems.BOOK_OF_BINDING_EMPTY.get())) {
                ItemStack dye = event.getEntity().getOffhandItem();
                if (dye.getCount() <= 3) continue;
                List<ItemStack> ingredients = List.of(ItemStack.EMPTY, dye, ItemStack.EMPTY, dye, bookShelf.getItem(i), dye, ItemStack.EMPTY, dye, ItemStack.EMPTY);
                CraftingInput input = CraftingInput.of((int)3, (int)3, ingredients);
                Optional optional = event.getLevel().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, event.getLevel());
                if (!optional.isPresent()) continue;
                bookShelf.setItem(i, BoundBookOfBindingRecipe.bookshelfCraft(((CraftingRecipe)((RecipeHolder)optional.get()).value()).getResultItem((HolderLookup.Provider)event.getLevel().registryAccess()).copy(), event.getItemStack()));
                if (event.getEntity().isCreative()) continue;
                dye.shrink(4);
                continue;
            }
            bookShelf.setItem(i, BoundBookOfBindingRecipe.bookshelfCraft(book.getDefaultInstance(), event.getItemStack()));
        }
        event.setCancellationResult(InteractionResult.FAIL);
        event.setCanceled(true);
        event.getEntity().swing(InteractionHand.MAIN_HAND);
    }

    @SubscribeEvent
    public static void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof SoulGemItem) {
            PartEntity partEntity;
            Entity entity;
            SoulGemItem soulGemItem = (SoulGemItem)item;
            Entity entity2 = event.getTarget();
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity2;
                if (soulGemItem.interactLivingEntity(stack, event.getEntity(), livingEntity, event.getHand()) == InteractionResult.SUCCESS) {
                    event.setCanceled(true);
                }
            }
            if ((entity = event.getTarget()) instanceof PartEntity && (entity = (partEntity = (PartEntity)entity).getParent()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (soulGemItem.interactLivingEntity(stack, event.getEntity(), livingEntity, event.getHand()) == InteractionResult.SUCCESS) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

