/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book.binding_rituals;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.mojang.datafixers.util.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class EntityWormholeEntry
extends EntryProvider {
    public static final String ENTRY_ID = "entity_wormhole";

    public EntityWormholeEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("spotlight", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.ENTITY_WORMHOLE.asItem()})).withText(this.context().pageText()));
        this.pageText("The [](item://occultism:entity_wormhole) is a mystical teleportation device maintained by a {0},\n capable of instantly transporting living beings across vast distances. Once attuned,\n it creates a stable rift that creatures can step through, linking distant points as if\n they were side by side. The Djinni ensures the wormhole remains open and aligned,\n making it a reliable\u2014though undeniably arcane\u2014means of travel.\n\n", new Object[]{this.color("Djinni", ChatFormatting.DARK_PURPLE)});
        this.page("ritual", () -> (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_entity_wormhole")));
        this.page("spotlight_dark", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.ENTITY_WORMHOLE_DARK.asItem()})).withText(this.context().pageText()));
        this.pageText("You can also choose the {0} version if you want.\n", new Object[]{this.itemLink((ItemLike)OccultismBlocks.OTHERROCK)});
        this.page("ritual_dark", () -> (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_entity_wormhole_dark")));
        this.page("destination", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Set destination");
        this.pageText("To set the destination, you''ll need a compass. Right-click to place it and shift+right-click to remove it.\n+ A standard compass takes you to the world spawn;\n+ A compass attached to a lodestone takes you to the top of it. (After placing it in the wormhole, the lodestone can be broken);\n");
        this.page("extra_uses", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Other compasses");
        this.pageText("+ A compass renamed \"{0}\" teleport for your personal spawn point;\n+ A compass renamed \"{1}\" acts as a Random Teleport;\n\\\nAlternatively, you can use special compasses:\n+ [](item://minecraft:recovery_compass) teleports to the location of your last death, works only for players;\n+ [](item://occultism:vitality_compass) teleports to the linked creature, it needs to be in a loaded chunk;\n", new Object[]{this.color("HOME", ChatFormatting.DARK_PURPLE), this.color("RTP", ChatFormatting.DARK_PURPLE)});
        this.page("exit_yaw", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Exit viewing direction");
        this.pageText("Using a [](item://occultism:spirit_attuned_gem) will define the yaw viewing angle after teleportation.\nAn iesnium nugget will point to the set direction like a compass rose.\n");
        this.page("exit_pitch", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Exit viewing inclination");
        this.pageText("If you hold the gem in your off-hand, it will change the pitch viewing angle.\n A six-pointed star in the center of the portal indicates the current setting:\n+ Emerald -> Forward\n+ Iron -> Tilted Down\n+ Redstone -> Straight Down\n+ Diamond -> Tilted Up\n+ Gold -> Straight Up\n");
        this.page("fishing", () -> BookSpotlightPageModel.create().withItem(Items.FISHING_ROD).withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Get over here!");
        this.pageText("If the wormhole contains an {0}, you can use a fishing rod to pull the linked\n entity into the portal, the hook needs to stop in the portal before you pull.\n", new Object[]{this.entryLink("Vitality Compass", "crafting_rituals", "vitality_compass")});
    }

    protected String entryName() {
        return "Entity Wormhole";
    }

    protected String entryDescription() {
        return "Fast travel";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)OccultismBlocks.ENTITY_WORMHOLE.asItem());
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

