/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.klikli_dev.occultism.common.block.RainbowGlyphBlock;
import com.klikli_dev.occultism.common.block.VoidGlyphBlock;
import com.klikli_dev.occultism.common.block.storage.StableWormholeBlock;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public class StandardBlockStateProvider
extends BlockStateProvider {
    public StandardBlockStateProvider(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "occultism", exFileHelper);
    }

    private void registerCubesBlockAndItem() {
        Block[] blocks;
        for (Block block : blocks = new Block[]{(Block)OccultismBlocks.CHISELED_OTHERROCK_BRICKS.get(), (Block)OccultismBlocks.CHISELED_OTHERSTONE_BRICKS.get(), (Block)OccultismBlocks.CRACKED_OTHERROCK_BRICKS.get(), (Block)OccultismBlocks.CRACKED_OTHERSTONE_BRICKS.get(), (Block)OccultismBlocks.IESNIUM_BLOCK.get(), (Block)OccultismBlocks.IESNIUM_ORE.get(), (Block)OccultismBlocks.OTHERCOBBLEROCK.get(), (Block)OccultismBlocks.OTHERCOBBLESTONE.get(), (Block)OccultismBlocks.OTHERPLANKS.get(), (Block)OccultismBlocks.OTHERROCK.get(), (Block)OccultismBlocks.OTHERSTONE.get(), (Block)OccultismBlocks.OTHERROCK_BRICKS.get(), (Block)OccultismBlocks.OTHERSTONE_BRICKS.get(), (Block)OccultismBlocks.POLISHED_OTHERROCK.get(), (Block)OccultismBlocks.POLISHED_OTHERSTONE.get(), (Block)OccultismBlocks.RAW_IESNIUM_BLOCK.get(), (Block)OccultismBlocks.RAW_SILVER_BLOCK.get(), (Block)OccultismBlocks.SILVER_BLOCK.get(), (Block)OccultismBlocks.SILVER_ORE.get(), (Block)OccultismBlocks.SILVER_ORE_DEEPSLATE.get(), (Block)OccultismBlocks.TALLOW_BLOCK.get()}) {
            this.simpleBlockWithItem(block, this.cubeAll(block));
        }
    }

    private void registerDirectionalBlock() {
        DeferredBlock[] blocks;
        for (DeferredBlock block : blocks = new DeferredBlock[]{OccultismBlocks.DARK_SACRIFICIAL_BOWL, OccultismBlocks.DARK_COPPER_SACRIFICIAL_BOWL, OccultismBlocks.DARK_SILVER_SACRIFICIAL_BOWL, OccultismBlocks.SACRIFICIAL_BOWL, OccultismBlocks.COPPER_SACRIFICIAL_BOWL, OccultismBlocks.SILVER_SACRIFICIAL_BOWL, OccultismBlocks.STORAGE_STABILIZER_TIER0, OccultismBlocks.STORAGE_STABILIZER_TIER1, OccultismBlocks.STORAGE_STABILIZER_TIER2, OccultismBlocks.STORAGE_STABILIZER_TIER3, OccultismBlocks.STORAGE_STABILIZER_TIER4, OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.ENTITY_WORMHOLE, OccultismBlocks.STORAGE_STABILIZER_TIER0_DARK, OccultismBlocks.STORAGE_STABILIZER_TIER1_DARK, OccultismBlocks.STORAGE_STABILIZER_TIER2_DARK, OccultismBlocks.STORAGE_STABILIZER_TIER3_DARK, OccultismBlocks.STORAGE_STABILIZER_TIER4_DARK, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK, OccultismBlocks.ENTITY_WORMHOLE_DARK}) {
            this.directionalBlock((Block)block.get(), (ModelFile)this.models().getExistingFile(this.modLoc(block.getKey().location().getPath())));
        }
    }

    protected void registerStatesAndModels() {
        this.registerCubesBlockAndItem();
        this.registerDirectionalBlock();
        OccultismBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(block -> block instanceof ChalkGlyphBlock && !(block instanceof RainbowGlyphBlock) && !(block instanceof VoidGlyphBlock)).forEach(this::generateGlyphBlockState);
        this.generateRainbowGlyphBlockState((Block)OccultismBlocks.CHALK_GLYPH_RAINBOW.get());
        this.generateVoidGlyphBlockState((Block)OccultismBlocks.CHALK_GLYPH_VOID.get());
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller")));
        this.models().withExistingParent("item/storage_controller", this.modLoc("block/storage_controller"));
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER_DARK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller_dark")));
        this.models().withExistingParent("item/storage_controller_dark", this.modLoc("block/storage_controller_dark"));
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER_BASE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller_base")));
        this.models().withExistingParent("item/storage_controller_base", this.modLoc("block/storage_controller_base"));
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER_BASE_DARK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller_base_dark")));
        this.models().withExistingParent("item/storage_controller_base_dark", this.modLoc("block/storage_controller_base_dark"));
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER_STABILIZED.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller_stabilized")));
        this.models().withExistingParent("item/storage_controller_stabilized", this.modLoc("block/storage_controller_stabilized"));
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER_STABILIZED_DARK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller_stabilized_dark")));
        this.models().withExistingParent("item/storage_controller_stabilized_dark", this.modLoc("block/storage_controller_stabilized_dark"));
        this.generateStableWormholeState((Block)OccultismBlocks.STABLE_WORMHOLE.get());
        this.generateStableWormholeStateDark((Block)OccultismBlocks.STABLE_WORMHOLE_DARK.get());
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERPLANKS_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERPLANKS.get()));
        this.fenceBlock((FenceBlock)OccultismBlocks.OTHERPLANKS_FENCE.get(), this.blockTexture((Block)OccultismBlocks.OTHERPLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)OccultismBlocks.OTHERPLANKS_FENCE_GATE.get(), this.blockTexture((Block)OccultismBlocks.OTHERPLANKS.get()));
        this.doorBlockWithRenderType((DoorBlock)OccultismBlocks.OTHERPLANKS_DOOR.get(), this.modLoc("block/otherplanks_door_bottom"), this.modLoc("block/otherplanks_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)OccultismBlocks.OTHERPLANKS_TRAPDOOR.get(), this.modLoc("block/otherplanks_trapdoor"), true, "cutout");
        this.pressurePlateBlock((PressurePlateBlock)OccultismBlocks.OTHERPLANKS_PRESSURE_PLATE.get(), this.blockTexture((Block)OccultismBlocks.OTHERPLANKS.get()));
        this.buttonBlock((ButtonBlock)OccultismBlocks.OTHERPLANKS_BUTTON.get(), this.blockTexture((Block)OccultismBlocks.OTHERPLANKS.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERSTONE_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.OTHERSTONE_SLAB.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE.get()), this.blockTexture((Block)OccultismBlocks.OTHERSTONE.get()));
        this.wallBlock((WallBlock)OccultismBlocks.OTHERSTONE_WALL.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE.get()));
        this.pressurePlateBlock((PressurePlateBlock)OccultismBlocks.OTHERSTONE_PRESSURE_PLATE.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE.get()));
        this.buttonBlock((ButtonBlock)OccultismBlocks.OTHERSTONE_BUTTON.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERCOBBLESTONE_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLESTONE.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.OTHERCOBBLESTONE_SLAB.get(), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLESTONE.get()), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLESTONE.get()));
        this.wallBlock((WallBlock)OccultismBlocks.OTHERCOBBLESTONE_WALL.get(), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLESTONE.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.POLISHED_OTHERSTONE_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERSTONE.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.POLISHED_OTHERSTONE_SLAB.get(), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERSTONE.get()), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERSTONE.get()));
        this.wallBlock((WallBlock)OccultismBlocks.POLISHED_OTHERSTONE_WALL.get(), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERSTONE.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERSTONE_BRICKS_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE_BRICKS.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.OTHERSTONE_BRICKS_SLAB.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE_BRICKS.get()), this.blockTexture((Block)OccultismBlocks.OTHERSTONE_BRICKS.get()));
        this.wallBlock((WallBlock)OccultismBlocks.OTHERSTONE_BRICKS_WALL.get(), this.blockTexture((Block)OccultismBlocks.OTHERSTONE_BRICKS.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERROCK_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERROCK.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.OTHERROCK_SLAB.get(), this.blockTexture((Block)OccultismBlocks.OTHERROCK.get()), this.blockTexture((Block)OccultismBlocks.OTHERROCK.get()));
        this.wallBlock((WallBlock)OccultismBlocks.OTHERROCK_WALL.get(), this.blockTexture((Block)OccultismBlocks.OTHERROCK.get()));
        this.pressurePlateBlock((PressurePlateBlock)OccultismBlocks.OTHERROCK_PRESSURE_PLATE.get(), this.blockTexture((Block)OccultismBlocks.OTHERROCK.get()));
        this.buttonBlock((ButtonBlock)OccultismBlocks.OTHERROCK_BUTTON.get(), this.blockTexture((Block)OccultismBlocks.OTHERROCK.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERCOBBLEROCK_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLEROCK.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.OTHERCOBBLEROCK_SLAB.get(), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLEROCK.get()), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLEROCK.get()));
        this.wallBlock((WallBlock)OccultismBlocks.OTHERCOBBLEROCK_WALL.get(), this.blockTexture((Block)OccultismBlocks.OTHERCOBBLEROCK.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.POLISHED_OTHERROCK_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERROCK.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.POLISHED_OTHERROCK_SLAB.get(), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERROCK.get()), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERROCK.get()));
        this.wallBlock((WallBlock)OccultismBlocks.POLISHED_OTHERROCK_WALL.get(), this.blockTexture((Block)OccultismBlocks.POLISHED_OTHERROCK.get()));
        this.stairsBlock((StairBlock)OccultismBlocks.OTHERROCK_BRICKS_STAIRS.get(), this.blockTexture((Block)OccultismBlocks.OTHERROCK_BRICKS.get()));
        this.slabBlock((SlabBlock)OccultismBlocks.OTHERROCK_BRICKS_SLAB.get(), this.blockTexture((Block)OccultismBlocks.OTHERROCK_BRICKS.get()), this.blockTexture((Block)OccultismBlocks.OTHERROCK_BRICKS.get()));
        this.wallBlock((WallBlock)OccultismBlocks.OTHERROCK_BRICKS_WALL.get(), this.blockTexture((Block)OccultismBlocks.OTHERROCK_BRICKS.get()));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_WHITE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_LIGHT_GRAY.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_GRAY.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_BLACK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_BROWN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_RED.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_ORANGE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_YELLOW.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_LIME.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_GREEN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_CYAN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_BLUE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_LIGHT_BLUE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_PINK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_MAGENTA.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
        this.simpleBlock((Block)OccultismBlocks.LARGE_CANDLE_PURPLE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/large_candle_white")));
    }

    protected void generateStableWormholeState(Block block) {
        ModelFile.ExistingModelFile linkedModel = this.models().getExistingFile(this.modLoc("block/stable_wormhole"));
        ModelFile.ExistingModelFile unlinkedModel = this.models().getExistingFile(this.modLoc("block/stable_wormhole_unlinked"));
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.getValue(StableWormholeBlock.LINKED) != false ? linkedModel : unlinkedModel)).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).build();
        });
    }

    protected void generateStableWormholeStateDark(Block block) {
        ModelFile.ExistingModelFile linkedModel = this.models().getExistingFile(this.modLoc("block/stable_wormhole_dark"));
        ModelFile.ExistingModelFile unlinkedModel = this.models().getExistingFile(this.modLoc("block/stable_wormhole_dark_unlinked"));
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.getValue(StableWormholeBlock.LINKED) != false ? linkedModel : unlinkedModel)).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).build();
        });
    }

    protected void generateGlyphBlockState(Block block) {
        ModelFile.ExistingModelFile parent = this.models().getExistingFile(this.modLoc("block/chalk_glyph/chalk_glyph"));
        this.getVariantBuilder(block).forAllStates(state -> {
            int sign = (Integer)state.getValue((Property)ChalkGlyphBlock.SIGN);
            ModelBuilder subModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/chalk_glyph/" + sign)).parent((ModelFile)parent)).texture("texture", this.modLoc("block/chalk_glyph/" + sign));
            return ConfiguredModel.builder().modelFile((ModelFile)subModel).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()).build();
        });
    }

    protected void generateRainbowGlyphBlockState(Block block) {
        ModelFile.ExistingModelFile parent = this.models().getExistingFile(this.modLoc("block/chalk_glyph/chalk_glyph"));
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int sign = (Integer)state.getValue((Property)ChalkGlyphBlock.SIGN);
            ModelBuilder subModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/chalk_glyph/" + sign)).parent((ModelFile)parent)).texture("texture", this.modLoc("block/chalk_glyph/" + sign));
            return ConfiguredModel.builder().modelFile((ModelFile)subModel).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()).build();
        }, new Property[]{RainbowGlyphBlock.COLOR});
    }

    protected void generateVoidGlyphBlockState(Block block) {
        ModelFile.ExistingModelFile parent = this.models().getExistingFile(this.modLoc("block/chalk_glyph/chalk_glyph"));
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int sign = (Integer)state.getValue((Property)ChalkGlyphBlock.SIGN);
            ModelBuilder subModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/chalk_glyph/" + sign)).parent((ModelFile)parent)).texture("texture", this.modLoc("block/chalk_glyph/" + sign));
            return ConfiguredModel.builder().modelFile((ModelFile)subModel).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()).build();
        }, new Property[]{VoidGlyphBlock.COLOR});
    }
}

