/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.occultism.integration.apothicenchanting.ApothicEnchantingIntegration;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class KnowledgeTabletItem
extends Item {
    public KnowledgeTabletItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.isShiftKeyDown()) {
                player.giveExperiencePoints(ItemNBTUtil.getStoredXP(stack));
                ItemNBTUtil.setStoredXP(stack, 0);
            } else {
                ItemNBTUtil.setStoredXP(stack, ItemNBTUtil.getStoredXP(stack) + ApothicEnchantingIntegration.getTotalExperiencePointsForLevel(player.experienceLevel) + (int)(serverPlayer.experienceProgress * (float)serverPlayer.getXpNeededForNextLevel()));
                serverPlayer.setExperiencePoints(0);
                serverPlayer.setExperienceLevels(0);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip"), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(pStack)), ChatFormatting.GREEN.toString() + ItemNBTUtil.getStoredXP(pStack) + String.valueOf(ChatFormatting.RESET)}));
    }
}

