/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.GoatFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.GoatFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.util.Color;

public class GoatFamiliarRenderer
extends MobRenderer<GoatFamiliarEntity, GoatFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/goat_familiar.png");

    public GoatFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GoatFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_GOAT)), 0.3f);
        this.addLayer(new BlackLayer(this, (RenderLayerParent<GoatFamiliarEntity, GoatFamiliarModel>)this, context));
    }

    public void render(GoatFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        float size = pEntity.getScale();
        pMatrixStack.scale(size, size, size);
        if (pEntity.isPartying()) {
            pMatrixStack.translate(0.0, -0.25, 0.0);
        } else if (pEntity.isSitting()) {
            pMatrixStack.translate(0.0, -0.3, 0.0);
        }
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.popPose();
    }

    public ResourceLocation getTextureLocation(GoatFamiliarEntity entity) {
        return TEXTURES;
    }

    private class BlackLayer
    extends RenderLayer<GoatFamiliarEntity, GoatFamiliarModel> {
        private final GoatFamiliarModel model;

        public BlackLayer(GoatFamiliarRenderer goatFamiliarRenderer, RenderLayerParent<GoatFamiliarEntity, GoatFamiliarModel> parent, EntityRendererProvider.Context context) {
            super(parent);
            this.model = new GoatFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_GOAT));
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, GoatFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!pLivingEntity.isInvisible() && pLivingEntity.isBlack()) {
                ((GoatFamiliarModel)this.getParentModel()).copyPropertiesTo(this.model);
                this.model.prepareMobModel(pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks);
                this.model.setupAnim(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                VertexConsumer ivertexbuilder = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)pLivingEntity)));
                this.model.renderToBuffer(pMatrixStack, ivertexbuilder, pPackedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)pLivingEntity, (float)0.0f), Color.ofRGBA((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f).getColor());
            }
        }
    }
}

