/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.item.combinedgoggles;

import com.klikli_dev.occultism.common.item.armor.OtherworldGogglesItem;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringItems;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CombinedGogglesItem
extends Item
implements Equipable {
    public CombinedGogglesItem(Item.Properties properties) {
        super(properties);
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    public boolean isFoil(ItemStack stack) {
        return OtherworldGogglesItem.isGogglesItem((ItemStack)stack) || super.isFoil(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (OtherworldGogglesItem.isGogglesItem((ItemStack)stack)) {
            tooltipComponents.add((Component)Component.translatable((String)"item.occultengineering.combined_goggles.otherworld_enabled").withStyle(ChatFormatting.LIGHT_PURPLE));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.occultengineering.combined_goggles.otherworld_disabled").withStyle(ChatFormatting.GRAY));
        }
        tooltipComponents.add((Component)Component.translatable((String)"item.occultengineering.combined_goggles.use_to_change"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isShiftKeyDown()) {
            return this.swapWithEquipmentSlot(stack.getItem(), level, player, usedHand);
        }
        stack.set((Supplier)OccultismDataComponents.OTHERWORLD_GOGGLES, (Object)(!OtherworldGogglesItem.isGogglesItem((ItemStack)stack) ? 1 : 0));
        return InteractionResultHolder.success((Object)stack);
    }

    static {
        GogglesItem.addIsWearingPredicate(player -> OccultEngineeringItems.COMBINED_GOGGLES.isIn(player.getItemBySlot(EquipmentSlot.HEAD)));
    }
}

