/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.item;

import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.mojang.datafixers.util.Either;
import com.simibubi.create.AllDataComponents;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentaclePrinter;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentacleSchematic;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringDataComponents;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringItems;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PentacleSchematicItem
extends Item {
    private static PentaclePrinter printer;

    public PentacleSchematicItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack create(ResourceLocation pentacleLocation) {
        ItemStack blueprint = OccultEngineeringItems.PENTACLE_SCHEMATIC.asStack();
        CompoundTag tag = new CompoundTag();
        blueprint.set(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)false);
        blueprint.set(OccultEngineeringDataComponents.PENTSCHEM_RESOURCE_LOCATION, (Object)pentacleLocation);
        blueprint.set(AllDataComponents.SCHEMATIC_ANCHOR, (Object)BlockPos.ZERO);
        blueprint.set(OccultEngineeringDataComponents.PENTSCHEM_BOUNDS, (Object)MultiblockDataManager.get().getMultiblock(pentacleLocation).getSize());
        return blueprint;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ResourceLocation pentacleResource;
        if (stack.has(OccultEngineeringDataComponents.PENTSCHEM_RESOURCE_LOCATION) && (pentacleResource = (ResourceLocation)stack.get(OccultEngineeringDataComponents.PENTSCHEM_RESOURCE_LOCATION)) != null) {
            tooltipComponents.add((Component)Component.translatable((String)"item.occultengineering.pentacle_schematic.tooltip_prefix").append((Component)Component.translatable((String)("multiblock." + pentacleResource.getNamespace() + "." + pentacleResource.getPath())).withStyle(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!stack.has(OccultEngineeringDataComponents.PENTSCHEM_RESOURCE_LOCATION)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (player.isShiftKeyDown() && player.onGround()) {
            if (player.isCreative()) {
                if (stack.has(AllDataComponents.SCHEMATIC_DEPLOYED) && stack.has(AllDataComponents.SCHEMATIC_ANCHOR)) {
                    Boolean deployed = (Boolean)stack.get(AllDataComponents.SCHEMATIC_DEPLOYED);
                    BlockPos tagPos = (BlockPos)stack.get(AllDataComponents.SCHEMATIC_ANCHOR);
                    if (deployed == null || tagPos == null) {
                        return InteractionResultHolder.fail((Object)stack);
                    }
                    if (deployed.booleanValue() && tagPos.equals((Object)player.blockPosition())) {
                        Either<PentacleSchematic, PentacleSchematic.ParseResult> schem = PentacleSchematic.fromStack(level, stack);
                        if (schem.left().isEmpty()) {
                            return InteractionResultHolder.fail((Object)stack);
                        }
                        ((PentacleSchematic)schem.orThrow()).instantPlace();
                        return InteractionResultHolder.success((Object)stack);
                    }
                }
                player.displayClientMessage((Component)Component.translatable((String)"gui.occultengineering.pentacle_schematic.place_hint_creative", (Object[])new Object[]{player.blockPosition().toShortString()}).withStyle(ChatFormatting.GREEN), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"gui.occultengineering.pentacle_schematic.place_hint", (Object[])new Object[]{player.blockPosition().toShortString()}).withStyle(ChatFormatting.GREEN), true);
            }
            stack.set(AllDataComponents.SCHEMATIC_ANCHOR, (Object)player.blockPosition());
            stack.set(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)true);
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

