/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.pucalith;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.block.pucalith.PucalithMenu;
import io.github.irishgreencitrus.occultengineering.content.fluid.FilteredFluidTankBehaviour;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentacleMaterialChecklist;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentaclePrinter;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentacleSchematic;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlockEntities;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringTags;
import java.util.LinkedHashSet;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PucalithBlockEntity
extends SmartBlockEntity
implements MenuProvider,
IInteractionChecker,
IHaveGoggleInformation {
    public static final int NEIGHBOUR_CHECK_MAX = 100;
    public State state;
    public PucalithInventory inventory = new PucalithInventory();
    private SmartFluidTankBehaviour internalTank;
    public PentaclePrinter printer = new PentaclePrinter();
    public PentacleSchematic schematic;
    public PentacleSchematic.ParseResult schematicParseResult;
    public int printerCooldown;
    public PentacleMaterialChecklist checklist = new PentacleMaterialChecklist();
    public boolean sendUpdate = false;
    public boolean shouldUpdateChecklist = false;
    public int neighborCheckCooldown = 0;
    public BlockPos previousTarget;
    public boolean hasCreativeCrate = false;
    public LinkedHashSet<IItemHandler> attachedInventories = new LinkedHashSet();
    public final int MAX_TANK_CAPACITY_MB = 2000;
    private final String INVENTORY_TAG = "Inventory";
    private final String PUCA_UUID_TAG = "PucaUUID";
    private final String CURRENT_STATE_TAG = "CurrentState";

    public PucalithBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.state = State.STOPPED;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)OccultEngineeringBlockEntities.PUCALITH.get(), (be, context) -> {
            if (context != null && context != Direction.UP) {
                return be.internalTank.getCapability();
            }
            return null;
        });
    }

    public void tick() {
        boolean shouldTryAgain;
        super.tick();
        if (this.neighborCheckCooldown-- <= 0) {
            this.neighborCheckCooldown = 100;
            this.findInventories();
        }
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.tickBookPrinter();
        for (int skipsLeft = 1000; skipsLeft >= 0 && (shouldTryAgain = this.tickPentaclePrinter()); --skipsLeft) {
        }
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 6);
        }
    }

    protected void tickBookPrinter() {
        boolean outputFull;
        int clipboardIn = 2;
        int clipboardOut = 3;
        ItemStack schematicItem = this.inventory.getStackInSlot(0);
        ItemStack clipboard = this.inventory.extractItem(clipboardIn, 1, true);
        boolean bl = outputFull = this.inventory.getStackInSlot(clipboardOut).getCount() == this.inventory.getSlotLimit(clipboardOut);
        if (!this.printer.isInitialised()) {
            if (!schematicItem.isEmpty()) {
                Either<PentacleSchematic, PentacleSchematic.ParseResult> schem = PentacleSchematic.fromStack(this.level, schematicItem);
                schem.ifLeft(schematic -> {
                    this.schematic = schematic;
                    this.checklist = new PentacleMaterialChecklist();
                    this.checklist.require(schematic.getItemRequirement());
                    this.printer.initialise((PentacleSchematic)schematic);
                });
            }
            return;
        }
        if (clipboard.isEmpty() || outputFull) {
            this.shouldUpdateChecklist = true;
            return;
        }
        if (this.shouldUpdateChecklist) {
            this.updateChecklist();
        }
        this.shouldUpdateChecklist = false;
        ItemStack extractedItem = this.inventory.extractItem(clipboardIn, 1, false);
        ItemStack stack = AllBlocks.CLIPBOARD.isIn(extractedItem) ? this.checklist.createWrittenClipboard() : this.checklist.createWrittenBook();
        stack.setCount(this.inventory.getStackInSlot(clipboardOut).getCount() + 1);
        this.inventory.setStackInSlot(clipboardOut, stack);
    }

    public void updateChecklist() {
        this.checklist.clear();
        if (this.schematic == null) {
            return;
        }
        if (this.printer.isInitialised()) {
            this.checklist.require(this.printer.getStillToPlaceRequrement());
        } else {
            this.checklist.require(this.schematic.getItemRequirement());
        }
        this.findInventories();
        for (IItemHandler cap : this.attachedInventories) {
            for (int slot = 0; slot < cap.getSlots(); ++slot) {
                ItemStack stack = cap.getStackInSlot(slot);
                if (cap.extractItem(slot, 1, true).isEmpty()) continue;
                this.checklist.collect(stack);
            }
        }
        this.sendUpdate = true;
    }

    public void findInventories() {
        this.hasCreativeCrate = false;
        this.attachedInventories.clear();
        for (Direction face : Iterate.directions) {
            IItemHandler itemHandler;
            BlockPos rel = this.worldPosition.relative(face);
            if (this.level == null || !this.level.isLoaded(rel)) continue;
            if (AllBlocks.CREATIVE_CRATE.has(this.level.getBlockState(rel))) {
                this.hasCreativeCrate = true;
                return;
            }
            BlockEntity be = this.level.getBlockEntity(rel);
            if (be == null || (itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), (Object)face.getOpposite())) == null) continue;
            this.attachedInventories.add(itemHandler);
        }
    }

    protected boolean tickPentaclePrinter() {
        assert (this.level != null);
        assert (!this.level.isClientSide());
        ItemStack blueprintItem = this.inventory.getStackInSlot(0);
        if (blueprintItem.isEmpty() && this.state != State.STOPPED && this.inventory.getStackInSlot(1).isEmpty()) {
            this.state = State.STOPPED;
            this.sendUpdate = true;
            return false;
        }
        if (this.state == State.STOPPED) {
            if (this.printer.isInitialised()) {
                this.resetPrinter();
            }
            return false;
        }
        if (!this.printer.isInitialised()) {
            this.initPrinter(blueprintItem);
            return false;
        }
        if (!this.level.isLoaded(this.schematic.position)) {
            return false;
        }
        if (this.printerCooldown-- > 0) {
            return false;
        }
        if (this.getTankRemaining() <= 0) {
            return false;
        }
        if (!this.printer.hasNextPlace()) {
            return false;
        }
        Pair<BlockPos, Either<BlockState, TagKey<Block>>> nextToPlace = this.printer.popNextToPlace();
        OccultEngineering.LOGGER.warn("Placing {} next", (Object)nextToPlace.toString());
        if (((Either)nextToPlace.getSecond()).left().isEmpty()) {
            return false;
        }
        BlockPos pos = (BlockPos)nextToPlace.getFirst();
        BlockState state = (BlockState)((Either)nextToPlace.getSecond()).left().orElseThrow();
        this.printerCooldown = 20;
        ItemRequirement requirement = this.printer.getStillToPlaceRequrement();
        this.sendUpdate = true;
        return false;
    }

    protected void initPrinter(ItemStack stack) {
        Either<PentacleSchematic, PentacleSchematic.ParseResult> schem = PentacleSchematic.fromStack(this.level, stack);
        this.sendUpdate = true;
        if (schem.left().isEmpty()) {
            this.state = State.STOPPED;
            this.schematicParseResult = (PentacleSchematic.ParseResult)((Object)schem.right().orElseThrow());
            return;
        }
        this.schematic = (PentacleSchematic)schem.left().get();
        this.printer.initialise(this.schematic);
        this.state = State.PAUSED;
        this.schematicParseResult = PentacleSchematic.ParseResult.OK;
    }

    public void resetPrinter() {
        this.printer.deinit();
        this.checklist.clear();
        this.schematic = null;
    }

    public void onPlayButton() {
        this.state = State.RUNNING;
    }

    public void onPauseButton() {
        this.state = State.PAUSED;
    }

    public void onStopButton() {
        this.state = State.STOPPED;
    }

    public void lazyTick() {
        super.lazyTick();
        this.findInventories();
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.inventory.deserializeNBT(registries, tag.getCompound("Inventory"));
        if (tag.contains("CurrentState")) {
            this.state = State.valueOf(tag.getString("CurrentState"));
        }
        super.read(tag, registries, clientPacket);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putString("CurrentState", this.state.toString());
        super.write(tag, registries, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.internalTank = FilteredFluidTankBehaviour.single(fluidStack -> fluidStack.getFluid().is(OccultEngineeringTags.PUCALITH_FUEL), this, 2000).allowInsertion().forbidExtraction();
        behaviours.add((BlockEntityBehaviour)this.internalTank);
    }

    public int getTankRemaining() {
        if (this.hasCreativeCrate) {
            return this.getTankCapacity();
        }
        return (int)this.internalTank.getPrimaryTank().getTotalUnits(0.0f);
    }

    public int getTankCapacity() {
        return 2000;
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return PucalithMenu.create(i, inventory, this);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.level == null) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition, (Object)Direction.UP));
    }

    public class PucalithInventory
    extends ItemStackHandler {
        public PucalithInventory() {
            super(4);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            PucalithBlockEntity.this.setChanged();
        }
    }

    public static enum State {
        STOPPED,
        PAUSED,
        RUNNING;

    }
}

