/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay.render;

import at.ridgo8.moreoverlays.api.lightoverlay.ILightRenderer;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class NumberOverlayRenderer
implements ILightRenderer {
    @Override
    public void renderOverlays(ILightScanner scanner, PoseStack matrixstack) {
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.enablePolygonOffset();
        RenderSystem.polygonOffset((float)-2.0f, (float)-4.0f);
        RenderSystem.depthMask((boolean)false);
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        MultiBufferSource.BufferSource bufferSource = Objects.requireNonNull(mc.renderBuffers().bufferSource());
        Camera camera = mc.gameRenderer.getMainCamera();
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        LocalPlayer player = mc.player;
        if (player == null || mc.level == null) {
            RenderSystem.disablePolygonOffset();
            return;
        }
        ClientLevel world = Objects.requireNonNull(mc.level);
        BlockPos playerPos = player.blockPosition();
        int up = (Integer)Config.light_UpRange.get();
        int down = (Integer)Config.light_DownRange.get();
        int hr = (Integer)Config.light_HRange.get();
        float scale = (float)((Double)Config.render_spawnNumberScale.get()).doubleValue();
        int save = (Integer)Config.light_SaveLevel.get();
        HashSet<BlockPos> spawnablePositions = new HashSet<BlockPos>();
        for (Pair<BlockPos, Byte> pair : scanner.getLightModes()) {
            if (pair.getRight() == null || (Byte)pair.getRight() == 0) continue;
            spawnablePositions.add((BlockPos)pair.getLeft());
        }
        for (int xo = -hr; xo <= hr; ++xo) {
            for (int zo = -hr; zo <= hr; ++zo) {
                for (int yo = -down; yo <= up; ++yo) {
                    BlockState airState;
                    BlockPos airPos = new BlockPos(playerPos.getX() + xo, playerPos.getY() + yo, playerPos.getZ() + zo);
                    BlockPos belowPos = airPos.below();
                    BlockState belowState = world.getBlockState(belowPos);
                    if (!belowState.isFaceSturdy((BlockGetter)world, belowPos, Direction.UP) || (airState = world.getBlockState(airPos)).isCollisionShapeFullBlock((BlockGetter)world, airPos)) continue;
                    int blockLight = world.getBrightness(LightLayer.BLOCK, airPos);
                    int skyLight = world.getBrightness(LightLayer.SKY, airPos);
                    if (blockLight == 0 && !spawnablePositions.contains(airPos)) continue;
                    int color = blockLight >= save ? 0xFF000000 | (Integer)Config.render_spawnSafeColor.get() : (skyLight >= save ? 0xFF000000 | (Integer)Config.render_spawnNColor.get() : 0xFF000000 | (Integer)Config.render_spawnAColor.get());
                    String text = String.valueOf(blockLight);
                    float y = airState.is(BlockTags.SNOW) ? (float)airPos.getY() + 0.125f + 0.02f : (float)belowPos.getY() + 1.0f + 0.02f;
                    matrixstack.pushPose();
                    matrixstack.translate((double)airPos.getX() + 0.5 + 0.045 - cameraX, (double)y - cameraY, (double)airPos.getZ() + 0.5 + 0.088 - cameraZ);
                    matrixstack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    matrixstack.scale(scale, -scale, scale);
                    float xoff = (float)(-font.width(text)) / 2.0f;
                    Objects.requireNonNull(font);
                    float yoff = (float)(-9) / 2.0f;
                    Matrix4f pose = matrixstack.last().pose();
                    font.drawInBatch(text, xoff, yoff, color, false, pose, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    matrixstack.popPose();
                }
            }
        }
        bufferSource.endBatch();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disablePolygonOffset();
    }
}

