/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.cc;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import com.google.common.collect.ImmutableList;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.compat.cc.CCBlockEntity;
import com.tom.morewires.compat.cc.ICCTile;
import com.tom.morewires.tile.IOnCable;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredElementCapability;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class CCConnectorBlockEntity
extends CCBlockEntity
implements IOnCable.IOnCableConnector,
ICCTile {
    protected GlobalWireNetwork globalNet;
    private boolean destroyed = false;
    private boolean connectionsFormed = false;
    private final WiredElement cable = new CableElement();
    private final WiredNode node = this.cable.getNode();
    private final TickScheduler.Token tickToken = new TickScheduler.Token((BlockEntity)this);
    private final ComponentAccess<WiredElement> connectedElements = PlatformHelper.get().createWiredElementAccess((BlockEntity)this, x -> this.connectionsChanged());
    private BlockCapabilityCache<WiredElement, Direction> connectedWire;
    private boolean isUnloaded = false;

    public CCConnectorBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public BlockState getState() {
        return this.getBlockState();
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        LocalWireNetwork local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.worldPosition, 0));
        if (local != null && !local.getConnections(this.worldPosition).isEmpty()) {
            return false;
        }
        return cableType == MoreImmersiveWires.CC_WIRE.simple().wireType;
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.setChanged();
    }

    public BlockPos getPosition() {
        return this.worldPosition;
    }

    @Override
    public Level getLevelNonnull() {
        return this.level;
    }

    public void setLevel(Level worldIn) {
        super.setLevel(worldIn);
        this.globalNet = GlobalWireNetwork.getNetwork((Level)worldIn);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorBlockEntityHelper.onChunkUnload((GlobalWireNetwork)this.globalNet, (IImmersiveConnectable)this);
        this.isUnloaded = true;
        this.onRemove();
    }

    public void onLoad() {
        super.onLoad();
        ConnectorBlockEntityHelper.onChunkLoad((IImmersiveConnectable)this, (Level)this.level);
        this.isUnloaded = false;
        if (!this.level.isClientSide) {
            BlockPos current = this.getBlockPos();
            Direction facing = this.getFacing();
            BlockPos offset = current.relative(facing);
            this.connectedWire = BlockCapabilityCache.create((BlockCapability)WiredElementCapability.get(), (ServerLevel)((ServerLevel)this.level), (BlockPos)offset, (Object)facing.getOpposite(), () -> !this.isRemoved(), () -> this.scheduleConnectionsChanged());
        }
    }

    void scheduleConnectionsChanged() {
        this.connectionsFormed = false;
        TickScheduler.schedule((TickScheduler.Token)this.tickToken);
    }

    public void setRemovedIE() {
        ConnectorBlockEntityHelper.remove((Level)this.level, (IImmersiveConnectable)this);
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
        this.onRemove();
    }

    private void onRemove() {
        if (this.level == null || !this.level.isClientSide) {
            this.node.remove();
            this.connectionsFormed = false;
            this.connectedWire = null;
        }
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.onRemove();
        }
    }

    void connectionsChanged() {
        if (this.getLevel().isClientSide || this.connectedWire == null) {
            return;
        }
        WiredElement element = (WiredElement)this.connectedWire.getCapability();
        if (element == null) {
            return;
        }
        WiredNode node = element.getNode();
        this.node.connectTo(node);
    }

    @Override
    public void blockTick() {
        if (this.getLevel().isClientSide) {
            return;
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
        }
    }

    @Override
    public WiredElement getElement() {
        return this.cable;
    }

    public void clearRemoved() {
        super.clearRemoved();
        TickScheduler.schedule((TickScheduler.Token)this.tickToken);
    }

    @Override
    public void onNeighbourTileEntityChange(BlockPos neighbour) {
        super.onNeighbourTileEntityChange(neighbour);
        if (!this.level.isClientSide) {
            TickScheduler.schedule((TickScheduler.Token)this.tickToken);
        }
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)MoreImmersiveWires.CC_WIRE.simple().NET_ID);
    }

    public WiredElement getCap(Direction side) {
        return side == this.getFacing() ? this.cable : null;
    }

    private class CableElement
    implements WiredElement {
        private final WiredNode node = ComputerCraftAPI.createWiredNodeForElement((WiredElement)this);

        private CableElement() {
        }

        public Level getLevel() {
            return CCConnectorBlockEntity.this.getLevel();
        }

        public Vec3 getPosition() {
            return Vec3.atCenterOf((Vec3i)CCConnectorBlockEntity.this.getBlockPos());
        }

        public WiredNode getNode() {
            return this.node;
        }

        public String getSenderID() {
            return "miw_connector";
        }
    }
}

