/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.portingdeadmods.moofluids.FluidUtils;
import com.portingdeadmods.moofluids.entity.FluidCow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.CowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;

public class RenderFluidCow
extends CowRenderer {
    public RenderFluidCow(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(Cow cow, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        FluidCow fCow = (FluidCow)cow;
        int color = FluidUtils.getFluidColor(fCow.getFluid());
        super.render((LivingEntity)cow, yaw, partialTicks, poseStack, buffer, packedLight);
        this.renderWithColor(cow, yaw, partialTicks, poseStack, buffer, packedLight, color);
    }

    public void renderWithColor(Cow cow, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int color) {
        poseStack.pushPose();
        ((CowModel)this.model).attackTime = this.getAttackAnim((LivingEntity)cow, partialTicks);
        ((CowModel)this.model).young = cow.isBaby();
        float bodyRotation = Mth.rotLerp((float)partialTicks, (float)cow.yBodyRotO, (float)cow.yBodyRot);
        float headRotation = Mth.rotLerp((float)partialTicks, (float)cow.yHeadRotO, (float)cow.yHeadRot);
        float headBodyRotationDifference = headRotation - bodyRotation;
        float pitch = Mth.lerp((float)partialTicks, (float)cow.xRotO, (float)cow.getXRot());
        if (RenderFluidCow.isEntityUpsideDown((LivingEntity)cow)) {
            pitch *= -1.0f;
            headBodyRotationDifference *= -1.0f;
        }
        this.setupRotations((LivingEntity)cow, poseStack, this.getBob((LivingEntity)cow, partialTicks), bodyRotation, partialTicks, 1.0f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntity)cow, poseStack, partialTicks);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        float walkSpeed = cow.walkAnimation.speed(partialTicks);
        float walkPosition = cow.walkAnimation.position(partialTicks);
        if (cow.isBaby()) {
            walkPosition *= 3.0f;
        }
        if (walkSpeed > 1.0f) {
            walkSpeed = 1.0f;
        }
        ((CowModel)this.model).prepareMobModel((Entity)cow, walkPosition, walkSpeed, partialTicks);
        ((CowModel)this.model).setupAnim((Entity)cow, walkPosition, walkSpeed, this.getBob((LivingEntity)cow, partialTicks), headBodyRotationDifference, pitch);
        Minecraft minecraft = Minecraft.getInstance();
        boolean isVisible = this.isBodyVisible((LivingEntity)cow);
        boolean isGlowing = minecraft.shouldEntityAppearGlowing((Entity)cow);
        RenderType renderType = this.getRenderType((LivingEntity)cow, isVisible, !isVisible && !cow.isInvisibleTo((Player)minecraft.player), isGlowing);
        if (renderType != null) {
            VertexConsumer vertexConsumer = buffer.getBuffer(renderType);
            int overlayCoords = RenderFluidCow.getOverlayCoords((LivingEntity)cow, (float)this.getWhiteOverlayProgress((LivingEntity)cow, partialTicks));
            ((CowModel)this.model).renderToBuffer(poseStack, vertexConsumer, packedLight, overlayCoords, color);
        }
        poseStack.popPose();
    }
}

