/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.compat.top;

import com.portingdeadmods.moofluids.FluidUtils;
import com.portingdeadmods.moofluids.block.entity.FluidCowJarBlockEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidType;

public final class FluidCowJarTopProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)"moofluids", (String)"top.fluid_cow_jar");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData data) {
        BlockEntity blockEntity = level.getBlockEntity(data.getPos());
        if (blockEntity instanceof FluidCowJarBlockEntity) {
            FluidCowJarBlockEntity fluidCowJar = (FluidCowJarBlockEntity)blockEntity;
            if (fluidCowJar.hasCow()) {
                if (fluidCowJar.getCowFluid() != Fluids.EMPTY) {
                    int color = FluidUtils.getFluidColor(fluidCowJar.getCowFluid());
                    FluidType fluidType = fluidCowJar.getCowFluid().getFluidType();
                    probeInfo.horizontal().text((Component)Component.translatable((String)"moofluids.top.fluid").append(": ").append((Component)Component.translatable((String)fluidType.getDescriptionId()).withStyle(Style.EMPTY.withColor(color))));
                }
                int fluidAmount = fluidCowJar.getFluidTank().getFluidAmount();
                int capacity = fluidCowJar.getFluidTank().getCapacity();
                probeInfo.horizontal().text((Component)Component.literal((String)"Fluid: ").append((Component)Component.literal((String)(fluidAmount + " / " + capacity + " mB")).withStyle(ChatFormatting.YELLOW)));
                if (!fluidCowJar.getFluidTank().isEmpty() && fluidCowJar.getFluidTank().getFluid().getFluid() != fluidCowJar.getCowFluid()) {
                    probeInfo.horizontal().text((Component)Component.translatable((String)"moofluids.top.fluid_mismatch").withStyle(ChatFormatting.RED));
                } else if (fluidCowJar.canBeMilked()) {
                    probeInfo.horizontal().text((Component)Component.translatable((String)"moofluids.top.ready").withStyle(ChatFormatting.GREEN));
                } else {
                    int cooldown = fluidCowJar.getMilkingCooldown();
                    probeInfo.horizontal().text((Component)Component.translatable((String)"moofluids.top.cooldown").append(": ").append((Component)Component.literal((String)String.valueOf(cooldown / 20 / 60)).withStyle(ChatFormatting.AQUA)).append("m ").append((Component)Component.literal((String)String.valueOf(cooldown / 20 % 60)).withStyle(ChatFormatting.AQUA)).append("s"));
                }
                if (fluidAmount < capacity) {
                    probeInfo.horizontal().text((Component)Component.literal((String)"Tank: Not Full").withStyle(ChatFormatting.YELLOW));
                } else {
                    probeInfo.horizontal().text((Component)Component.literal((String)"Tank: Full").withStyle(ChatFormatting.RED));
                }
            } else {
                probeInfo.horizontal().text((Component)Component.literal((String)"Empty - Place cow and crush with anvil").withStyle(ChatFormatting.GRAY));
            }
        }
    }
}

