/*
 * Decompiled with CFR 0.152.
 */
package dev.ferriarnus.monocle.bootstrap;

import cpw.mods.jarhandling.JarContents;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonocleModLocator
implements IModFileCandidateLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Monocle/IrisModParser");

    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        URL url = MonocleModLocator.class.getResource("/META-INF/jarjar/monocle-mod-file.jar");
        try {
            Path path;
            Path path2 = path = url != null ? Paths.get(url.toURI()) : null;
            if (path == null || !Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("Monocle JAR does not exist!");
            }
            LOGGER.info("Located Monocle mod jar at {}", (Object)path);
            pipeline.addJarContent(JarContents.of((Path)path), ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.WARN_ALWAYS);
        }
        catch (Exception e) {
            LOGGER.error("Fatal error encountered locating Monocle JAR", (Throwable)e);
        }
    }
}

