/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module.adapter;

import java.util.List;
import java.util.Set;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ITargetedModule;
import me.desht.modularrouters.item.module.TargetValidation;
import me.desht.modularrouters.item.module.adapter.IItemAdapter;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public record TargetedModuleAdapter(ITargetedModule targeted) implements IItemAdapter
{
    @Override
    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getPlayer() != null && ctx.getPlayer().isShiftKeyDown()) {
            if (this.targeted.getMaxTargets() == 1) {
                if (ITargetedModule.canSelectTarget(ctx)) {
                    this.handleSingleTarget(ctx.getItemInHand(), ctx.getPlayer(), ctx.getLevel(), ctx.getClickedPos(), ctx.getClickedFace());
                    return InteractionResult.SUCCESS;
                }
            } else {
                return this.handleMultiTarget(ctx.getItemInHand(), ctx, ctx.getPlayer(), ctx.getLevel(), ctx.getClickedPos(), ctx.getClickedFace());
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<ItemStack> onSneakRightClick(ItemStack stack, Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide && !ITargetedModule.getTargets(stack, false).isEmpty() && this.targeted.getMaxTargets() == 1) {
            ITargetedModule.setTargets(stack, Set.of());
            world.playSound(null, player.blockPosition(), ModSounds.SUCCESS.get(), SoundSource.BLOCKS, ((Double)ConfigHolder.common.sound.bleepVolume.get()).floatValue(), 1.1f);
            player.displayClientMessage((Component)Component.translatable((String)"modularrouters.chatText.misc.targetCleared").withStyle(ChatFormatting.YELLOW), true);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void handleSingleTarget(ItemStack stack, Player player, Level world, BlockPos pos, Direction face) {
        if (!world.isClientSide) {
            ITargetedModule.setTargets(stack, Set.of(new ModuleTarget(world, pos, face)));
            Set<ModuleTarget> tgts = ITargetedModule.getTargets(stack, true);
            if (!tgts.isEmpty()) {
                MutableComponent msg = Component.translatable((String)"modularrouters.chatText.misc.targetSet").append(tgts.iterator().next().getTextComponent());
                player.displayClientMessage((Component)msg.withStyle(ChatFormatting.YELLOW), true);
                world.playSound(null, pos, ModSounds.SUCCESS.get(), SoundSource.BLOCKS, ((Double)ConfigHolder.common.sound.bleepVolume.get()).floatValue(), 1.3f);
            }
        }
    }

    private InteractionResult handleMultiTarget(ItemStack stack, UseOnContext context, Player player, Level world, BlockPos pos, Direction face) {
        Set<ModuleTarget> targets = ITargetedModule.getTargets(stack, !world.isClientSide);
        String invName = BlockUtil.getBlockName(world, pos);
        GlobalPos gPos = MiscUtil.makeGlobalPos(world, pos);
        ModuleTarget tgt = new ModuleTarget(gPos, face, invName);
        if (targets.contains(tgt)) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            targets.remove(tgt);
            player.displayClientMessage((Component)Component.translatable((String)"modularrouters.chatText.misc.targetRemoved", (Object[])new Object[]{targets.size(), this.targeted.getMaxTargets()}).append(tgt.getTextComponent()).withStyle(ChatFormatting.YELLOW), true);
            world.playSound(null, pos, ModSounds.SUCCESS.get(), SoundSource.BLOCKS, ((Double)ConfigHolder.common.sound.bleepVolume.get()).floatValue(), 1.1f);
            ITargetedModule.setTargets(stack, targets);
            return InteractionResult.SUCCESS;
        }
        if (ITargetedModule.canSelectTarget(context)) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (targets.size() < this.targeted.getMaxTargets()) {
                targets.add(tgt);
                player.displayClientMessage((Component)Component.translatable((String)"modularrouters.chatText.misc.targetAdded", (Object[])new Object[]{targets.size(), this.targeted.getMaxTargets()}).append(tgt.getTextComponent()).withStyle(ChatFormatting.YELLOW), true);
                world.playSound(null, pos, ModSounds.SUCCESS.get(), SoundSource.BLOCKS, ((Double)ConfigHolder.common.sound.bleepVolume.get()).floatValue(), 1.3f);
                ITargetedModule.setTargets(stack, targets);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"modularrouters.chatText.misc.tooManyTargets", (Object[])new Object[]{this.targeted.getMaxTargets()}).withStyle(ChatFormatting.RED), true);
                world.playSound(null, pos, ModSounds.ERROR.get(), SoundSource.BLOCKS, 1.0f, 1.3f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void addSettingsInformation(ItemStack stack, List<Component> list) {
        Set<ModuleTarget> targets = ITargetedModule.getTargets(stack, false);
        for (ModuleTarget target : targets) {
            if (target == null) continue;
            MutableComponent msg = Component.literal((String)"\u25b6 ").append((Component)MiscUtil.asMutableComponent(target.getTextComponent()).withStyle(ChatFormatting.WHITE));
            list.add((Component)msg);
            ClientUtil.getOpenItemRouter().ifPresent(router -> {
                ModuleTarget moduleTarget = new ModuleTarget(router.getGlobalPos());
                TargetValidation val = this.validateTarget(stack, moduleTarget, target, false);
                if (val != TargetValidation.OK) {
                    list.add((Component)ClientUtil.xlate(val.translationKey(), new Object[0]).withStyle(val.getColor()));
                }
            });
        }
    }

    @Override
    public void doModuleValidation(ItemStack stack, ServerPlayer player) {
        ModuleTarget src = new ModuleTarget(MiscUtil.makeGlobalPos(player.getCommandSenderWorld(), player.blockPosition()));
        Set<ModuleTarget> targets = ITargetedModule.getTargets(stack, true);
        for (ModuleTarget target : targets) {
            if (target == null) continue;
            TargetValidation v = this.validateTarget(stack, src, target, true);
            MutableComponent msg = MiscUtil.asMutableComponent(target.getTextComponent()).append(" ").append((Component)Component.translatable((String)v.translationKey()).withStyle(v.getColor()));
            player.displayClientMessage((Component)msg, false);
        }
    }

    private TargetValidation validateTarget(ItemStack moduleStack, ModuleTarget src, ModuleTarget dst, boolean validateBlocks) {
        if (this.targeted.isRangeLimited() && (!src.isSameWorld(dst) || src.gPos.pos().distSqr((Vec3i)dst.gPos.pos()) > (double)this.maxDistanceSq(moduleStack))) {
            return TargetValidation.OUT_OF_RANGE;
        }
        if (validateBlocks) {
            ServerLevel w = MiscUtil.getWorldForGlobalPos(dst.gPos);
            if (w == null || !w.getChunkSource().hasChunk(dst.gPos.pos().getX() >> 4, dst.gPos.pos().getZ() >> 4)) {
                return TargetValidation.NOT_LOADED;
            }
            if (w.getBlockEntity(dst.gPos.pos()) == null) {
                return TargetValidation.NOT_INVENTORY;
            }
            if (!this.targeted.canOperateInDimension((ResourceKey<Level>)dst.gPos.dimension()) || !this.targeted.canOperateInDimension((ResourceKey<Level>)src.gPos.dimension())) {
                return TargetValidation.BAD_DIMENSION;
            }
        }
        return TargetValidation.OK;
    }

    private int maxDistanceSq(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IRangedModule) {
            IRangedModule rangedModule = (IRangedModule)item;
            int r = rangedModule.getCurrentRange(stack);
            return r * r;
        }
        return 0;
    }

    @Override
    public void addUsageInformation(ItemStack itemstack, List<Component> list) {
        list.add((Component)ClientUtil.xlate(this.targeted.getMaxTargets() > 1 ? "modularrouters.itemText.targetingHintMulti" : "modularrouters.itemText.targetingHint", new Object[0]).withStyle(ChatFormatting.YELLOW));
    }
}

