/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items.gadget;

import com.direwolf20.mininggadgets.common.containers.handlers.DataComponentHandler;
import com.direwolf20.mininggadgets.common.util.CodecHelpers;
import com.direwolf20.mininggadgets.setup.MGDataComponents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class MiningProperties {
    private static final String KEY_BEAM_RANGE = "beamRange";
    private static final String KEY_MAX_BEAM_RANGE = "maxBeamRange";
    private static final String KEY_WHITELIST = "isWhitelist";
    private static final String KEY_RANGE = "range";
    private static final String KEY_MAX_MINING_RANGE = "maxMiningRange";
    private static final String KEY_SIZE_MODE = "sizeMode";
    private static final String KEY_SPEED = "speed";
    private static final String BREAK_TYPE = "breakType";
    private static final String CAN_MINE = "canMine";
    private static final String PRECISION_MODE = "precisionMode";
    private static final String VOLUME = "volume";
    private static final String FREEZE_PARTICLE_DELAY = "freeze_particle_delay";
    private static final String KEY_BATTERY_TIER = "battery_tier";
    public static final String KEY_FILTERS = "filters";
    public static final String COLOR_RED = "colorRed";
    public static final String COLOR_GREEN = "colorGreen";
    public static final String COLOR_BLUE = "colorBlue";
    public static final String COLOR_RED_INNER = "colorRedInner";
    public static final String COLOR_GREEN_INNER = "colorGreenInner";
    public static final String COLOR_BLUE_INNER = "colorBlueInner";
    public static final int MIN_RANGE = 5;

    private MiningProperties() {
    }

    public static CodecHelpers.LaserColor getColors(ItemStack gadget) {
        return (CodecHelpers.LaserColor)gadget.getOrDefault(MGDataComponents.LASER_COLOR, (Object)new CodecHelpers.LaserColor(255, 0, 0, 255, 255, 255));
    }

    public static void setColor(ItemStack gadget, CodecHelpers.LaserColor laserColor) {
        gadget.set(MGDataComponents.LASER_COLOR, (Object)laserColor);
    }

    public static void setBreakType(ItemStack gadget, BreakTypes breakType) {
        gadget.set(MGDataComponents.BREAK_TYPE, (Object)((byte)breakType.ordinal()));
    }

    public static void nextBreakType(ItemStack gadget) {
        if (gadget.has(MGDataComponents.BREAK_TYPE)) {
            int type = MiningProperties.getBreakType(gadget).ordinal() == BreakTypes.values().length - 1 ? 0 : MiningProperties.getBreakType(gadget).ordinal() + 1;
            MiningProperties.setBreakType(gadget, BreakTypes.values()[type]);
        } else {
            MiningProperties.setBreakType(gadget, BreakTypes.FADE);
        }
    }

    public static BreakTypes getBreakType(ItemStack gadget) {
        return BreakTypes.values()[(Byte)gadget.getOrDefault(MGDataComponents.BREAK_TYPE, (Object)0)];
    }

    public static void setSpeed(ItemStack gadget, int speed) {
        gadget.set(MGDataComponents.SPEED, (Object)speed);
    }

    public static int getSpeed(ItemStack gadget) {
        return (Integer)gadget.getOrDefault(MGDataComponents.SPEED, (Object)1);
    }

    public static void setRange(ItemStack gadget, int range) {
        gadget.set(MGDataComponents.RANGE, (Object)range);
    }

    public static int getRange(ItemStack gadget) {
        return (Integer)gadget.getOrDefault(MGDataComponents.RANGE, (Object)1);
    }

    public static void setBeamRange(ItemStack gadget, int range) {
        gadget.set(MGDataComponents.BEAM_RANGE, (Object)range);
    }

    public static void setBeamMaxRange(ItemStack gadget, int range) {
        gadget.set(MGDataComponents.MAX_BEAM_RANGE, (Object)range);
    }

    public static int getBeamRange(ItemStack gadget) {
        return (Integer)gadget.getOrDefault(MGDataComponents.BEAM_RANGE, (Object)5);
    }

    public static int getBeamMaxRange(ItemStack gadget) {
        return (Integer)gadget.getOrDefault(MGDataComponents.MAX_BEAM_RANGE, (Object)5);
    }

    public static void setMaxMiningRange(ItemStack gadget, int range) {
        gadget.set(MGDataComponents.MAX_MINING_RANGE, (Object)range);
    }

    public static int getMaxMiningRange(ItemStack gadget) {
        return (Integer)gadget.getOrDefault(MGDataComponents.MAX_MINING_RANGE, (Object)1);
    }

    public static void setWhitelist(ItemStack gadget, boolean isWhitelist) {
        gadget.set(MGDataComponents.WHITELIST, (Object)isWhitelist);
    }

    public static boolean getWhiteList(ItemStack gadget) {
        return (Boolean)gadget.getOrDefault(MGDataComponents.WHITELIST, (Object)true);
    }

    public static void setCanMine(ItemStack gadget, boolean canMine) {
        gadget.set(MGDataComponents.CAN_MINE, (Object)canMine);
    }

    public static boolean getCanMine(ItemStack gadget) {
        return (Boolean)gadget.getOrDefault(MGDataComponents.CAN_MINE, (Object)true);
    }

    public static void setPrecisionMode(ItemStack gadget, boolean precisionMode) {
        gadget.set(MGDataComponents.PRECISION_MODE, (Object)precisionMode);
    }

    public static boolean getPrecisionMode(ItemStack gadget) {
        return (Boolean)gadget.getOrDefault(MGDataComponents.PRECISION_MODE, (Object)false);
    }

    public static void setSizeMode(ItemStack gadget, SizeMode sizeMode) {
        gadget.set(MGDataComponents.SIZE_MODE, (Object)((byte)sizeMode.ordinal()));
    }

    public static SizeMode nextSizeMode(ItemStack gadget) {
        if (gadget.has(MGDataComponents.SIZE_MODE)) {
            int type = MiningProperties.getSizeMode(gadget).ordinal() == SizeMode.values().length - 1 ? 0 : MiningProperties.getSizeMode(gadget).ordinal() + 1;
            MiningProperties.setSizeMode(gadget, SizeMode.values()[type]);
        } else {
            MiningProperties.setSizeMode(gadget, SizeMode.NORMAL);
        }
        return MiningProperties.getSizeMode(gadget);
    }

    public static SizeMode getSizeMode(ItemStack gadget) {
        return SizeMode.values()[(Byte)gadget.getOrDefault(MGDataComponents.SIZE_MODE, (Object)((byte)SizeMode.AUTO.ordinal()))];
    }

    public static void setVolume(ItemStack gadget, float volume) {
        gadget.set(MGDataComponents.VOLUME, (Object)Float.valueOf(volume));
    }

    public static float getVolume(ItemStack gadget) {
        return ((Float)gadget.getOrDefault(MGDataComponents.VOLUME, (Object)Float.valueOf(1.0f))).floatValue();
    }

    public static void setFreezeDelay(ItemStack gadget, int freezeDelay) {
        gadget.set(MGDataComponents.FREEZE_DELAY, (Object)freezeDelay);
    }

    public static int getFreezeDelay(ItemStack gadget) {
        return (Integer)gadget.getOrDefault(MGDataComponents.FREEZE_DELAY, (Object)0);
    }

    public static void setBatteryTier(ItemStack gadget, int tier) {
        gadget.set(MGDataComponents.BATTERY_TIER, (Object)tier);
    }

    public static int getBatteryTier(ItemStack gadget) {
        return (Integer)gadget.getOrDefault(MGDataComponents.BATTERY_TIER, (Object)0);
    }

    public static List<ItemStack> getFiltersAsList(ItemStack gadget) {
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        DataComponentHandler ghostInventory = new DataComponentHandler(gadget, 30);
        for (int i = 0; i < ghostInventory.getSlots(); ++i) {
            ItemStack itemStack = ghostInventory.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            returnList.add(itemStack);
        }
        return returnList;
    }

    public static List<ItemStack> deserializeItemStackList(CompoundTag nbt, HolderLookup.Provider provider) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ListTag tagList = nbt.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            stacks.add(ItemStack.parse((HolderLookup.Provider)provider, (Tag)itemTags).orElse(ItemStack.EMPTY));
        }
        return stacks;
    }

    public static CompoundTag serializeItemStackList(List<ItemStack> stacks, HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            nbtTagList.add((Object)stacks.get(i).save(provider, (Tag)itemTag));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        nbt.putInt("Size", stacks.size());
        return nbt;
    }

    public static enum BreakTypes {
        SHRINK,
        FADE;

    }

    public static enum SizeMode {
        AUTO("auto"),
        NORMAL("normal"),
        PATHWAY("pathway");

        private final String baseName;

        private SizeMode(String baseName) {
            this.baseName = baseName;
        }

        public Component getTooltip() {
            return Component.translatable((String)("mininggadgets.tooltip.screen.sizemode." + this.baseName));
        }
    }
}

