/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.entity.ai;

import dev.ftb.mods.mecrh.config.ServerConfig;
import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.entity.ai.ChickenGoal;
import dev.ftb.mods.mecrh.registry.ModSounds;
import dev.ftb.mods.mecrh.util.ChickenUtils;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ChickenSpinGoal
extends ChickenGoal {
    public static final int MAX_SPIN_TIME = 100;
    private int spinTicks;

    public ChickenSpinGoal(EnderChicken chicken) {
        super(chicken);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean canUse() {
        if (this.chicken.canUseAbility() && !this.chicken.isClearingArea() && !this.chicken.isSpinning() && this.chicken.isSpinReady() && !this.chicken.isFiringLaser()) {
            return this.chicken.getTarget() != null && this.chicken.getTarget().isAlive();
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.chicken.isAlive() && this.spinTicks < 100;
    }

    public void start() {
        this.chicken.useAbility();
        this.spinTicks = 0;
        this.chicken.setSpinning(true);
    }

    public void stop() {
        this.chicken.endAbility();
        this.chicken.setSpinning(false);
    }

    public void tick() {
        ++this.spinTicks;
        if (this.spinTicks == 10) {
            this.chicken.playSound((SoundEvent)ModSounds.CHICKEN_SPIN.get(), 1.0f, 1.0f);
        }
        if (this.spinTicks > 10) {
            float eggChance = (float)this.spinTicks / 50.0f;
            if (this.chicken.getRandom().nextFloat() < eggChance) {
                this.chicken.launchEggBomb(ServerConfig.getEggSpeed(this.chicken.getRandom()), this.chicken.getRandom().nextBoolean());
            }
        }
        ChickenUtils.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partWingL.getBlockDestructionAABB());
        ChickenUtils.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partWingR.getBlockDestructionAABB());
        ChickenUtils.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partHead.getBlockDestructionAABB());
        ChickenUtils.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partBill.getBlockDestructionAABB());
    }
}

