/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.entity.ai;

import dev.ftb.mods.mecrh.MECRHMod;
import dev.ftb.mods.mecrh.config.ServerConfig;
import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.entity.ai.ChickenGoal;
import dev.ftb.mods.mecrh.event.EnderChickenEvent;
import dev.ftb.mods.mecrh.registry.ModAttachments;
import dev.ftb.mods.mecrh.util.ChickenUtils;
import dev.ftb.mods.mecrh.util.Raytracing;
import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ChickenCluckstormGoal
extends ChickenGoal {
    private static final ResourceLocation STRAY_SCALE_MOD_ID = MECRHMod.id("stray_scale");
    public static final AttributeModifier STRAY_SCALE_MOD = new AttributeModifier(STRAY_SCALE_MOD_ID, -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private float targetYaw;

    public ChickenCluckstormGoal(EnderChicken chicken) {
        super(chicken);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.chicken.canUseAbility() && !this.chicken.isFiringLaser() && !this.chicken.hasCluckstormed() && (double)(this.chicken.getHealth() / this.chicken.getMaxHealth()) <= 0.5;
    }

    public boolean canContinueToUse() {
        return this.chicken.isFiringLaser() && this.chicken.isAlive() && this.chicken.getFiringProgress() < 160;
    }

    public void start() {
        this.chicken.useAbility();
        this.chicken.setFiringLaser(true);
        this.chicken.setHasCluckstormed();
        BlockHitResult bhr = Raytracing.getFocusedBlock(this.chicken, (Integer)ServerConfig.ARENA_RADIUS.get() * 2);
        Vec3 startTarget = bhr.getType() == HitResult.Type.BLOCK ? Vec3.atCenterOf((Vec3i)bhr.getBlockPos()) : this.chicken.partBill.position().add(this.chicken.getLookAngle().normalize().scale((double)((Integer)ServerConfig.ARENA_RADIUS.get()).intValue() / 2.0));
        Vec3 offset = startTarget.subtract(this.chicken.partBill.position());
        this.targetYaw = (float)Math.atan2(offset.z, offset.x);
        ChickenUtils.postChickenEvent(this.chicken, EnderChickenEvent.Phase.STAMPEDE_THRESHOLD);
    }

    public void stop() {
        this.chicken.setFiringLaser(false);
        this.chicken.endAbility();
    }

    public void tick() {
        super.tick();
        float warmup = 59.0f;
        float prog = (float)this.chicken.getFiringProgress() > warmup ? ((float)this.chicken.getFiringProgress() - warmup) / (160.0f - warmup) : 0.0f;
        double x = this.chicken.position().x + (double)Mth.cos((float)(this.targetYaw + prog * ((float)Math.PI * 2))) * 10.0;
        double z = this.chicken.position().z + (double)Mth.sin((float)(this.targetYaw + prog * ((float)Math.PI * 2))) * 10.0;
        double y = this.chicken.level().getHeight(Heightmap.Types.WORLD_SURFACE, (int)x, (int)z);
        this.chicken.getLookControl().setLookAt(x, y, z);
        if (this.chicken.getFiringProgress() == 59) {
            this.spawnStrayRiders();
        }
    }

    private void spawnStrayRiders() {
        int nMobs = (Integer)ServerConfig.STRAY_COUNT.get();
        for (int i = 0; i < nMobs; ++i) {
            float angle = 360.0f / (float)nMobs * (float)i * ((float)Math.PI / 180);
            float dist = 3.0f + this.chicken.getRandom().nextFloat() * 4.0f;
            Vec3 spawnPos = this.chicken.position().add((double)(Mth.cos((float)angle) * dist), 0.0, Math.sin(angle) * (double)dist);
            int y = this.chicken.level().getHeight(Heightmap.Types.WORLD_SURFACE, (int)spawnPos.x, (int)spawnPos.z);
            spawnPos = new Vec3(spawnPos.x, (double)y + 1.0, spawnPos.z);
            Chicken chicken1 = new Chicken(EntityType.CHICKEN, this.chicken.level());
            chicken1.setData(ModAttachments.CHICKEN_ID, (Object)this.chicken.getId());
            chicken1.setPos(spawnPos);
            Stray stray = new Stray(EntityType.STRAY, this.chicken.level());
            stray.setPos(spawnPos);
            stray.setData(ModAttachments.CHICKEN_ID, (Object)this.chicken.getId());
            this.chicken.level().addFreshEntity((Entity)chicken1);
            this.chicken.level().addFreshEntity((Entity)stray);
            AttributeInstance scale = stray.getAttribute(Attributes.SCALE);
            if (scale != null) {
                scale.addPermanentModifier(STRAY_SCALE_MOD);
            }
            stray.startRiding((Entity)chicken1);
            this.chicken.playSound(SoundEvents.VILLAGER_HURT);
            Level level = this.chicken.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.8f, 0.2f), 1.0f), spawnPos.x, spawnPos.y, spawnPos.z, 15, 0.2, 0.2, 0.2, 0.1);
        }
    }
}

