/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.entity.ai;

import dev.ftb.mods.mecrh.config.ServerConfig;
import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.entity.ai.ChickenGoal;
import dev.ftb.mods.mecrh.registry.ModSounds;
import dev.ftb.mods.mecrh.util.ChickenUtils;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ChickenChargeGoal
extends ChickenGoal {
    private static final double KNOCKBACK_AMP = 7.0;
    private final boolean peckOfDoom;
    private final int totalDuration;
    private final int warmupTime;
    private Vec3 chargeStart;
    private int chargeTime;
    private Vec3 chargePos;
    private boolean dropPhase;

    public ChickenChargeGoal(EnderChicken chicken, boolean peckOfDoom) {
        super(chicken);
        this.peckOfDoom = peckOfDoom;
        this.totalDuration = peckOfDoom ? (Integer)ServerConfig.MAX_PECK_CHARGE_TIME.get() + (Integer)ServerConfig.PECK_DROP_TIME.get() : (Integer)ServerConfig.MAX_CHARGE_TIME.get();
        this.warmupTime = peckOfDoom ? (Integer)ServerConfig.PECK_WARMUP_TIME.get() : (Integer)ServerConfig.CHARGE_WARMUP_TIME.get();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.chicken.isChargeReady(this.peckOfDoom) && !this.chicken.isCharging();
    }

    public boolean canContinueToUse() {
        return this.chicken.isAlive() && this.chargeTime < this.totalDuration && this.chargeStart.distanceToSqr(this.chicken.position()) < (Double)ServerConfig.MAX_CHARGE_DIST.get() * (Double)ServerConfig.MAX_CHARGE_DIST.get() && (this.peckOfDoom || this.chargePos == null || this.chargePos.distanceToSqr(this.chicken.position()) > 2.0) && this.chicken.isWithinRestriction();
    }

    public void start() {
        this.chargeTime = 0;
        this.dropPhase = false;
        this.chargeStart = this.chicken.position();
        this.chicken.useAbility();
        this.chicken.setCharging(true, this.peckOfDoom);
    }

    public void stop() {
        this.chicken.setSprinting(false);
        this.chicken.setCharging(false, this.peckOfDoom);
        this.chicken.endAbility();
    }

    public void tick() {
        LivingEntity target = this.chicken.getTarget();
        if (this.chargeTime < this.warmupTime) {
            if (this.chargeTime == 0) {
                float p = this.peckOfDoom ? 1.2f : 0.8f;
                this.chicken.playSound(SoundEvents.ENDER_DRAGON_GROWL, 1.2f, p + this.chicken.getRandom().nextFloat() * 0.4f);
            }
            this.chicken.setYRot(this.chicken.yBodyRot);
            if (target != null) {
                this.chicken.getLookControl().setLookAt((Entity)target);
            }
        } else {
            this.chicken.setSprinting(true);
            if (this.chargeTime == this.warmupTime) {
                Vec3 vec3 = this.chargePos = target == null ? this.chicken.position().add(this.chicken.getLookAngle().normalize().scale(6.0)) : target.position();
                if (this.peckOfDoom) {
                    this.chargePos = this.chargePos.add(0.0, ((Double)ServerConfig.DIST_ABOVE_TARGET.get()).doubleValue(), 0.0);
                } else {
                    this.chicken.playSound((SoundEvent)ModSounds.CHARGE_START.get(), 1.2f, 0.8f);
                }
                this.chargeStart = this.chicken.position();
            }
            this.chicken.getLookControl().setLookAt(target == null ? this.chargePos : target.position());
            if (this.peckOfDoom && (this.chargeTime > (Integer)ServerConfig.MAX_PECK_CHARGE_TIME.get() || this.chicken.position().distanceToSqr(this.chargePos) < 1.0)) {
                this.dropPhase = true;
            }
            if (this.dropPhase) {
                if (!this.chicken.onGround()) {
                    this.chicken.setDeltaMovement(0.0, -1.0, 0.0);
                }
                if (this.chicken.onGround() || this.chargeTime >= this.totalDuration - 1) {
                    this.doPeckOfDoomShockwave();
                    this.chargeTime = this.totalDuration;
                }
            } else {
                Vec3 vec = this.chargePos.subtract(this.chicken.position()).normalize();
                ChickenUtils.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partBody.getBlockDestructionAABB().expandTowards(vec));
                ChickenUtils.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partHead.getBlockDestructionAABB().expandTowards(vec));
                ChickenUtils.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partBill.getBlockDestructionAABB().expandTowards(vec));
                ChickenUtils.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partFootL.getBlockDestructionAABB().expandTowards(vec).move(0.0, 1.0, 0.0));
                ChickenUtils.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partFootR.getBlockDestructionAABB().expandTowards(vec).move(0.0, 1.0, 0.0));
                if (this.peckOfDoom) {
                    Vec3 offset = this.chargePos.subtract(this.chicken.position());
                    double len = offset.length() / (Double)ServerConfig.CHARGE_SPEED.get();
                    this.chicken.setDeltaMovement(offset.x / len, offset.y / len, offset.z / len);
                } else {
                    this.chicken.getNavigation().moveTo(this.chargePos.x, this.chargePos.y, this.chargePos.z, 2.0);
                }
            }
            if (this.chargeTime % 2 == 0) {
                this.knockbackEntities(e -> {});
            }
        }
        ++this.chargeTime;
    }

    private static Vec3 calcChargePos(PathfinderMob mob, LivingEntity target) {
        Vec3 offset = target.position().subtract(mob.position());
        return mob.position().add(offset.add(offset.normalize().scale(2.5)));
    }

    private void doPeckOfDoomShockwave() {
        this.knockbackEntities(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity l = (LivingEntity)e;
                l.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 80, 2));
                l.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 80, 2));
            }
        });
        Vec3 pos = this.chicken.position();
        this.chicken.level().explode((Entity)this.chicken, pos.x, pos.y, pos.z, 3.0f, Level.ExplosionInteraction.NONE);
        Level level = this.chicken.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ASH, pos.x, pos.y, pos.z, 25, 2.0, 1.0, 2.0, 0.5);
        }
    }

    private void knockbackEntities(Consumer<Entity> consumer) {
        Level level = this.chicken.level();
        Vec3 diff = this.chicken.getDeltaMovement();
        HashSet collided = new HashSet();
        collided.addAll(level.getEntities((Entity)this.chicken, this.chicken.partFootL.getBoundingBox().expandTowards(diff), EnderChicken.PREDICATE_TARGETS));
        collided.addAll(level.getEntities((Entity)this.chicken, this.chicken.partFootR.getBoundingBox().expandTowards(diff), EnderChicken.PREDICATE_TARGETS));
        collided.addAll(level.getEntities((Entity)this.chicken, this.chicken.partLegL.getBoundingBox().expandTowards(diff), EnderChicken.PREDICATE_TARGETS));
        collided.addAll(level.getEntities((Entity)this.chicken, this.chicken.partLegR.getBoundingBox().expandTowards(diff), EnderChicken.PREDICATE_TARGETS));
        collided.addAll(level.getEntities((Entity)this.chicken, this.chicken.partBody.getBoundingBox().expandTowards(diff), EnderChicken.PREDICATE_TARGETS));
        collided.forEach(e -> {
            consumer.accept((Entity)e);
            double xOff = e.getX() - this.chicken.getX();
            double yOff = e.getY() + (e.getBoundingBox().maxY - e.getBoundingBox().minY) / 2.0 - this.chicken.getY();
            double zOff = e.getZ() - this.chicken.getZ();
            double distSq = xOff * xOff + yOff * yOff + zOff * zOff + this.chicken.getRandom().nextGaussian() * 1.0E-5;
            if (distSq < (double)(this.chicken.getBbHeight() * this.chicken.getBbHeight())) {
                Vec3 knockback = new Vec3(7.0 / distSq * (xOff * xOff / distSq) * (xOff > 0.0 ? 1.0 : -1.0), 10.5 / distSq * (yOff * yOff / distSq) * (yOff > 0.0 ? 1.0 : -1.0) + 0.07, 7.0 / distSq * (zOff * zOff / distSq) * (zOff > 0.0 ? 1.0 : -1.0));
                e.setDeltaMovement(e.getDeltaMovement().add(knockback).add(this.chicken.getDeltaMovement()));
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    sp.connection.send((Packet)new ClientboundSetEntityMotionPacket(e.getId(), e.getDeltaMovement()));
                }
                e.hasImpulse = true;
            }
            e.hurt(level.damageSources().mobAttack((LivingEntity)this.chicken), ((Double)ServerConfig.CHARGE_DAMAGE.get()).floatValue());
        });
    }
}

