/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.entity;

import dev.ftb.mods.mecrh.entity.EnderChicken;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.entity.PartEntity;

public class EnderChickenPart
extends PartEntity<EnderChicken> {
    private final EntityDimensions size;
    private final PartType type;

    public EnderChickenPart(EnderChicken parent, PartType type, float width, float height) {
        super((Entity)parent);
        this.type = type;
        this.size = EntityDimensions.scalable((float)width, (float)height);
        this.noPhysics = true;
        this.refreshDimensions();
    }

    public PartType getPartType() {
        return this.type;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        return ((EnderChicken)this.getParent()).getPickResult();
    }

    public boolean hurt(DamageSource source, float amount) {
        return source.getEntity() != this.getParent() && !this.isInvulnerableTo(source) && ((EnderChicken)this.getParent()).attackFromPart(source, this, amount);
    }

    public boolean is(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        throw new UnsupportedOperationException();
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.size;
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public AABB getBlockDestructionAABB() {
        return this.getBoundingBox().expandTowards(((EnderChicken)this.getParent()).getDeltaMovement()).inflate((double)this.getBbWidth() / 3.0);
    }

    public static enum PartType {
        FOOT_L,
        FOOT_R,
        LEG_L,
        LEG_R,
        BODY,
        WING_L,
        WING_R,
        HEAD,
        BILL;

    }
}

