/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.entity;

import dev.ftb.mods.mecrh.config.ServerConfig;
import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.entity.EnderChickenPart;
import dev.ftb.mods.mecrh.registry.ModEntityTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EggBomb
extends ThrowableProjectile {
    public int explodeTimer;
    private boolean huntTarget;

    public EggBomb(EntityType<EggBomb> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    public EggBomb(Level level, LivingEntity shooter) {
        super(ModEntityTypes.EGG_BOMB.get(), shooter, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void huntTarget(boolean huntTarget) {
        this.huntTarget = huntTarget;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            EnderChicken chicken;
            Entity entity;
            if (this.explodeTimer > 0 && --this.explodeTimer == 0) {
                this.explode();
            }
            if (this.tickCount > 100) {
                this.explode();
            }
            if (this.huntTarget && this.getRandom().nextFloat() < 0.6f && (entity = this.getOwner()) instanceof EnderChicken && (chicken = (EnderChicken)entity).getTarget() != null) {
                Vec3 offset = chicken.getTarget().position().subtract(this.position());
                this.setDeltaMovement(this.getDeltaMovement().add(offset.normalize().scale(0.1).add(0.0, 0.1, 0.0)));
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        this.explodeTimer = 10;
        return true;
    }

    protected void onHit(HitResult result) {
        EntityHitResult ehr;
        if (result instanceof EntityHitResult && ((ehr = (EntityHitResult)result).getEntity() instanceof EnderChicken || ehr.getEntity() instanceof EnderChickenPart)) {
            return;
        }
        if (this.tickCount > 5 && !this.level().isClientSide && this.isAlive()) {
            this.explode();
        }
    }

    private void explode() {
        this.discard();
        float radius = ((Double)ServerConfig.EGG_BOMB_EXPLOSION_POWER.get()).floatValue();
        Level.ExplosionInteraction interaction = (Boolean)ServerConfig.EGG_BOMB_DAMAGE_TERRAIN.get() != false ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
        this.level().explode(this.getOwner(), this.getX(), this.getY(), this.getZ(), radius, false, interaction);
    }
}

