/*
 * Decompiled with CFR 0.152.
 */
package dev.tonimatas.mekanismcurios.networking;

import dev.tonimatas.mekanismcurios.util.CuriosSlots;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record QuickTeleportActionPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<QuickTeleportActionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mekanismcurios", (String)"quick_teleport_action_packet"));
    public static final StreamCodec<FriendlyByteBuf, QuickTeleportActionPacket> STREAM_CODEC = StreamCodec.unit((Object)new QuickTeleportActionPacket());

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(QuickTeleportActionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Item patt0$temp;
            ServerPlayer player = (ServerPlayer)context.player();
            ItemStack stack = CuriosSlots.TELEPORTER.getItemStack((Player)player);
            if (!stack.isEmpty() && (patt0$temp = stack.getItem()) instanceof ItemPortableTeleporter) {
                ItemPortableTeleporter item = (ItemPortableTeleporter)patt0$temp;
                Frequency.FrequencyIdentity identity = QuickTeleportActionPacket.getIdentity(item, stack);
                if (identity == null) {
                    player.sendSystemMessage((Component)Component.translatable((String)"key.mekanismcurios.quickteleport.notconnected").withStyle(ChatFormatting.RED));
                    return;
                }
                TeleporterFrequency found = (TeleporterFrequency)FrequencyType.TELEPORTER.getFrequency(identity, player.getUUID());
                if (found == null) {
                    return;
                }
                GlobalPos coords = found.getClosestCoords(GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)player.blockPosition()));
                if (coords != null) {
                    MinecraftServer server = player.level().getServer();
                    ServerLevel teleWorld = server == null ? null : server.getLevel(coords.dimension());
                    TileEntityTeleporter teleporter = (TileEntityTeleporter)WorldUtils.getTileEntity(TileEntityTeleporter.class, (BlockGetter)teleWorld, (BlockPos)coords.pos());
                    if (teleporter != null) {
                        long energyCost;
                        Runnable energyExtraction = null;
                        if (!player.isCreative()) {
                            energyCost = TileEntityTeleporter.calculateEnergyCost((Entity)player, (Level)teleWorld, (GlobalPos)coords);
                            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
                            if (energyContainer == null || energyContainer.extract(energyCost, Action.SIMULATE, AutomationType.MANUAL) < energyCost) {
                                player.sendSystemMessage((Component)Component.translatable((String)"key.mekanismcurios.quickteleport.noenergy").withStyle(ChatFormatting.RED));
                                return;
                            }
                            energyExtraction = () -> energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
                        } else {
                            energyCost = 0L;
                        }
                        try {
                            teleporter.didTeleport.add(player.getUUID());
                            teleporter.teleDelay = 5;
                            BlockPos teleporterTargetPos = teleporter.getTeleporterTargetPos();
                            MekanismTeleportEvent.PortableTeleporter event = new MekanismTeleportEvent.PortableTeleporter((Player)player, teleporterTargetPos, coords.dimension(), stack, energyCost);
                            if (((MekanismTeleportEvent.PortableTeleporter)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                                return;
                            }
                            if (energyExtraction != null) {
                                energyExtraction.run();
                            }
                            player.connection.aboveGroundTickCount = 0;
                            player.closeContainer();
                            PacketUtils.sendToAllTracking((CustomPacketPayload)new PacketPortalFX(player.blockPosition()), (Level)player.level(), (BlockPos)coords.pos());
                            if (player.isPassenger()) {
                                player.stopRiding();
                            }
                            double oldX = player.getX();
                            double oldY = player.getY();
                            double oldZ = player.getZ();
                            Level oldWorld = player.level();
                            TileEntityTeleporter.teleportEntityTo((Entity)player, (Level)teleWorld, (TileEntityTeleporter)teleporter, (MekanismTeleportEvent.Teleporter)event, (boolean)false, (DimensionTransition.PostDimensionTransition)DimensionTransition.DO_NOTHING);
                            if (player.level() != oldWorld || player.distanceToSqr(oldX, oldY, oldZ) >= 25.0) {
                                oldWorld.playSound(null, oldX, oldY, oldZ, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
                            }
                            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
                            teleporter.sendTeleportParticles();
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"key.mekanismcurios.quickteleport.notfound").withStyle(ChatFormatting.RED));
                }
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"key.mekanismcurios.quickteleport.empty").withStyle(ChatFormatting.RED));
            }
        });
    }

    private static Frequency.FrequencyIdentity getIdentity(ItemPortableTeleporter teleporter, ItemStack stack) {
        DataComponentType frequencyComponent = MekanismDataComponents.getFrequencyComponent((FrequencyType)teleporter.getFrequencyType());
        if (frequencyComponent == null) {
            return null;
        }
        FrequencyAware frequencyAware = (FrequencyAware)stack.get(frequencyComponent);
        if (frequencyAware != null) {
            return frequencyAware.identity().orElse(null);
        }
        return null;
    }
}

