/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.part;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.items.parts.PartModels;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import com.mebeamformer.client.render.BeamRenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BeamFormerPart
extends AEBasePart
implements IGridTickable {
    private static final ResourceLocation MODEL_BASE_LOC = ResourceLocation.fromNamespaceAndPath((String)"me_beam_former", (String)"part/beam_former_base");
    private static final IPartModel MODEL = new PartModel(MODEL_BASE_LOC);
    private int beamLength = 0;
    private BeamFormerPart other = null;
    private IGridConnection connection = null;
    private boolean hideBeam = false;

    public BeamFormerPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this);
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return List.of(MODEL);
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 16.0, 11.0, 11.0, 10.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 11.0);
        bch.addBox(7.0, 7.0, 20.0, 9.0, 9.0, 16.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    public boolean onUseWithoutItem(Player player, Vec3 pos) {
        if (player.isShiftKeyDown()) {
            if (!player.level().isClientSide) {
                boolean bl = this.hideBeam = !this.hideBeam;
                if (this.other != null) {
                    this.other.hideBeam = this.hideBeam;
                    this.other.getHost().markForUpdate();
                    this.other.getHost().markForSave();
                }
                this.getHost().markForUpdate();
                this.getHost().markForSave();
            }
            return true;
        }
        return false;
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(5, 10, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        IPartHost host = this.getHost();
        BlockEntity be = host.getBlockEntity();
        Level level = be.getLevel();
        if (level == null) {
            return TickRateModulation.SLEEP;
        }
        Direction dir = this.getSide();
        BlockPos cur = be.getBlockPos();
        Direction facing = dir;
        LinkedHashSet<BlockPos> path = new LinkedHashSet<BlockPos>();
        boolean found = false;
        BeamFormerPart target = null;
        for (int i = 0; i < 32; ++i) {
            cur = cur.relative(facing);
            BlockState state = level.getBlockState(cur);
            BlockEntity otherBe = level.getBlockEntity(cur);
            boolean hasBeamFormerPart = false;
            if (otherBe instanceof IPartHost) {
                IPartHost ph = (IPartHost)otherBe;
                Direction opposite = facing.getOpposite();
                IPart p = ph.getPart(opposite);
                if (p instanceof BeamFormerPart) {
                    BeamFormerPart bf;
                    target = bf = (BeamFormerPart)p;
                    found = true;
                }
                for (Direction d : Direction.values()) {
                    if (!(ph.getPart(d) instanceof BeamFormerPart)) continue;
                    hasBeamFormerPart = true;
                    break;
                }
            }
            if (state.canOcclude() && !state.isAir()) {
                if (hasBeamFormerPart) {
                    path.add(cur);
                    if (!found || target == null || otherBe != target.getBlockEntity()) continue;
                    break;
                }
                this.disconnect(null);
                return TickRateModulation.SLOWER;
            }
            path.add(cur);
            if (found && target != null) break;
        }
        if (found && target != null) {
            if (this.other == target && target.other == this && this.connection != null) {
                int oldLen = this.beamLength;
                this.beamLength = path.size();
                if (oldLen != this.beamLength) {
                    this.getHost().markForUpdate();
                }
                return TickRateModulation.SLOWER;
            }
            this.tryConnect(target, path);
            return TickRateModulation.SLOWER;
        }
        if (this.connection != null || this.other != null || this.beamLength != 0) {
            this.disconnect(null);
            return TickRateModulation.SLOWER;
        }
        return TickRateModulation.SLOWER;
    }

    public Direction getDirection() {
        return this.getSide();
    }

    public boolean isValidClient() {
        BlockEntity be = this.getBlockEntity();
        Level level = be != null ? be.getLevel() : null;
        return level != null && level == Minecraft.getInstance().level;
    }

    public int getBeamLength() {
        return this.beamLength;
    }

    public boolean shouldRenderBeam() {
        if (this.hideBeam) {
            return false;
        }
        if (this.beamLength <= 0 && this.other == null) {
            return false;
        }
        if (!this.isPowered()) {
            return false;
        }
        return this.other == null || this.other.isPowered();
    }

    public int getLightLevel() {
        return this.shouldRenderBeam() ? 15 : 0;
    }

    public boolean requireDynamicRender() {
        return true;
    }

    public void renderDynamic(float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        int checkLen;
        if (!this.shouldRenderBeam()) {
            return;
        }
        BlockEntity be = this.getBlockEntity();
        Level levelRD = be != null ? be.getLevel() : null;
        Direction dirRD = this.getSide();
        int n = checkLen = this.beamLength > 0 ? this.beamLength : 1;
        if (levelRD != null && !this.isPathClearForRender(levelRD, be.getBlockPos(), dirRD, checkLen)) {
            return;
        }
        AEColor color = this.getHost().getColor();
        float scale = 255.0f;
        float r = (float)(color.blackVariant >> 16 & 0xFF) / scale;
        float g = (float)(color.blackVariant >> 8 & 0xFF) / scale;
        float b = (float)(color.blackVariant & 0xFF) / scale;
        Direction dir = this.getSide();
        double visibleLen = this.beamLength > 0 ? (double)this.beamLength : 0.5;
        BeamRenderHelper.renderColoredBeamForPart(poseStack, buffers, dir, visibleLen, r, g, b, combinedLightIn, combinedOverlayIn);
    }

    private boolean isPathClearForRender(Level level, BlockPos start, Direction dir, int length) {
        BlockPos cur = start;
        for (int i = 0; i < length; ++i) {
            BlockState state = level.getBlockState(cur = cur.relative(dir));
            if (!state.canOcclude() || state.isAir()) continue;
            BlockEntity otherBe = level.getBlockEntity(cur);
            if (otherBe instanceof IPartHost) {
                IPartHost ph = (IPartHost)otherBe;
                boolean hasBeamFormerPart = false;
                for (Direction d : Direction.values()) {
                    if (!(ph.getPart(d) instanceof BeamFormerPart)) continue;
                    hasBeamFormerPart = true;
                    break;
                }
                if (hasBeamFormerPart) continue;
            }
            return false;
        }
        return true;
    }

    private void tryConnect(BeamFormerPart target, Set<BlockPos> path) {
        IGridNode a = this.getGridNode();
        IGridNode b = target.getGridNode();
        if (a == null || b == null) {
            return;
        }
        this.disconnect(null);
        target.disconnect(null);
        this.connection = GridHelper.createConnection((IGridNode)a, (IGridNode)b);
        this.other = target;
        target.other = this;
        this.beamLength = path.size();
        target.beamLength = path.size();
        if (this.hideBeam || target.hideBeam) {
            this.hideBeam = true;
            target.hideBeam = true;
        }
        this.getHost().markForUpdate();
        this.getHost().markForSave();
        this.getHost().partChanged();
        target.getHost().markForUpdate();
        target.getHost().markForSave();
        target.getHost().partChanged();
    }

    public boolean disconnect(BlockPos breakPos) {
        boolean changed = false;
        if (this.connection != null) {
            this.connection.destroy();
            this.connection = null;
            changed = true;
        }
        if (this.other != null) {
            this.other.other = null;
            this.other.getHost().markForUpdate();
            this.other.getHost().markForSave();
            this.other = null;
            changed = true;
        }
        this.beamLength = breakPos != null ? Math.max(0, Math.min(this.beamLength, breakPos.distManhattan((Vec3i)this.getBlockEntity().getBlockPos()))) : 0;
        if (changed) {
            this.getHost().markForUpdate();
            this.getHost().markForSave();
            this.getHost().partChanged();
        }
        return changed;
    }

    public void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeVarInt(this.beamLength);
        data.writeBoolean(this.hideBeam);
    }

    public boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean redraw = super.readFromStream(data);
        int oldLen = this.beamLength;
        boolean oldHide = this.hideBeam;
        this.beamLength = data.readVarInt();
        this.hideBeam = data.readBoolean();
        return redraw || oldLen != this.beamLength || oldHide != this.hideBeam;
    }

    public void writeToNBT(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeToNBT(tag, registries);
        CompoundTag v = new CompoundTag();
        v.putInt("beamLength", this.beamLength);
        v.putBoolean("hideBeam", this.hideBeam);
        tag.put("beamFormer", (Tag)v);
    }

    public void readFromNBT(CompoundTag tag, HolderLookup.Provider registries) {
        super.readFromNBT(tag, registries);
        if (tag.contains("beamFormer")) {
            CompoundTag v = tag.getCompound("beamFormer");
            this.beamLength = v.getInt("beamLength");
            this.hideBeam = v.getBoolean("hideBeam");
        }
    }
}

