/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.energy;

import com.mebeamformer.blockentity.WirelessEnergyTowerBlockEntity;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class FluxEnergyAdapter {
    private static volatile Class<?> FLUX_INTERFACE_CLASS = null;
    private static volatile boolean FLUX_CHECKED = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Object createFluxAdapter(WirelessEnergyTowerBlockEntity tower) {
        if (!FLUX_CHECKED) {
            Class<FluxEnergyAdapter> clazz = FluxEnergyAdapter.class;
            // MONITORENTER : com.mebeamformer.energy.FluxEnergyAdapter.class
            if (!FLUX_CHECKED) {
                try {
                    FLUX_INTERFACE_CLASS = Class.forName("sonar.fluxnetworks.api.energy.IFNEnergyStorage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                FLUX_CHECKED = true;
            }
            // MONITOREXIT : clazz
        }
        if (FLUX_INTERFACE_CLASS == null) {
            return null;
        }
        try {
            return Proxy.newProxyInstance(FLUX_INTERFACE_CLASS.getClassLoader(), new Class[]{FLUX_INTERFACE_CLASS}, (InvocationHandler)new FluxInvocationHandler(tower));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class FluxInvocationHandler
    implements InvocationHandler {
        private final WirelessEnergyTowerBlockEntity tower;

        public FluxInvocationHandler(WirelessEnergyTowerBlockEntity tower) {
            this.tower = tower;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            switch (methodName = method.getName()) {
                case "receiveEnergyL": {
                    if (args != null && args.length >= 2) {
                        return this.tower.receiveEnergyL((Long)args[0], (Boolean)args[1]);
                    }
                    return 0L;
                }
                case "extractEnergyL": {
                    if (args != null && args.length >= 2) {
                        return this.tower.extractEnergyL((Long)args[0], (Boolean)args[1]);
                    }
                    return 0L;
                }
                case "getEnergyStoredL": {
                    return this.tower.getEnergyStoredL();
                }
                case "getMaxEnergyStoredL": {
                    return this.tower.getMaxEnergyStoredL();
                }
                case "canExtract": {
                    return this.tower.canExtract();
                }
                case "canReceive": {
                    return this.tower.canReceive();
                }
                case "receiveEnergy": {
                    if (args != null && args.length >= 2) {
                        return this.tower.receiveEnergy((Integer)args[0], (Boolean)args[1]);
                    }
                    return 0;
                }
                case "extractEnergy": {
                    if (args != null && args.length >= 2) {
                        return this.tower.extractEnergy((Integer)args[0], (Boolean)args[1]);
                    }
                    return 0;
                }
                case "getEnergyStored": {
                    return this.tower.getEnergyStored();
                }
                case "getMaxEnergyStored": {
                    return this.tower.getMaxEnergyStored();
                }
            }
            return null;
        }
    }
}

