/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.attack;

import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.WeaponParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedWeaponParticleEffectType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.PointyDirectionalParticleBehavior;

public class AscensionRadialSlashParticleEffect
extends MalumNetworkedWeaponParticleEffectType<WeaponParticleEffectType.WeaponParticleEffectData> {
    public AscensionRadialSlashParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, WeaponParticleEffectType.WeaponParticleEffectData extraData) {
        Vec3 direction = extraData.getDirection();
        float yRot = (float)(Mth.atan2((double)direction.x, (double)direction.z) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot);
        Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
        for (int i = 0; i < 3; ++i) {
            Vec3 pos = positionData.getAsVector();
            for (int j = 0; j < 16; ++j) {
                float spinOffset = extraData.getSlashRotation() + RandomHelper.randomBetween((RandomSource)random, (float)-0.5f, (float)0.5f) + (extraData.isMirrored() ? 3.14f : 0.0f);
                float slashAngle = ((float)i * 0.33f + (float)j) / 16.0f * (float)Math.PI * 2.0f;
                Vec3 slashDirection = left.scale(Math.sin(slashAngle)).add(direction.scale(Math.cos(slashAngle))).normalize();
                Vec3 slashPosition = pos.add(slashDirection.scale((double)0.14f));
                ParticleEffectSpawner slash = WeaponParticleEffects.spawnSlashParticle(level, slashPosition, MalumParticles.ROUNDABOUT_SLASH, colorData);
                slash.getBuilder().setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)0.0f).setSpinOffset(spinOffset).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)2.5f, (float)5.0f)).build()).setMotion(slashDirection.scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.05f, (float)0.2f)).add(0.0, (double)0.2f, 0.0)).setLifetime(12 + i).setLifeDelay(i + j / 4).setBehavior((LodestoneParticleBehavior)PointyDirectionalParticleBehavior.pointyDirectional((Vec3)slashDirection));
                slash.spawnParticles();
            }
            ParticleEffectSpawner slash = WeaponParticleEffects.spawnSlashParticle(level, pos, MalumParticles.ROUNDABOUT_SLASH, colorData);
            slash.getBuilder().setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)0.0f).setSpinOffset((float)i * 1.57f).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)4.5f, (float)5.0f)).build()).setLifetime(12).setLifeDelay(i * 2).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0)));
            slash.spawnParticles();
        }
    }
}

