/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked;

import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectColorData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPayload;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectType;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;

public abstract class MalumNetworkedParticleEffectType<T extends NetworkedParticleEffectExtraData>
extends NetworkedParticleEffectType<T> {
    public MalumNetworkedParticleEffectType(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectColorData>> getColorCodec() {
        return Optional.of(MalumNetworkedParticleEffectColorData.STREAM_CODEC);
    }

    protected void castAndAct(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, NetworkedParticleEffectColorData colorData, NetworkedParticleEffectExtraData extraData) {
        this.act(level, random, positionData, (MalumNetworkedParticleEffectColorData)colorData, (T)extraData);
    }

    public abstract void act(Level var1, RandomSource var2, NetworkedParticleEffectPositionData var3, MalumNetworkedParticleEffectColorData var4, T var5);

    public final void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, NetworkedParticleEffectColorData colorData, T extraData) {
    }

    public MalumParticleEffectBuilder<T> createEffect(BlockPos position) {
        return this.createEffect().at(position);
    }

    public MalumParticleEffectBuilder<T> createEffect(Vec3 position) {
        return this.createEffect().at(position);
    }

    public MalumParticleEffectBuilder<T> createEffect(Entity target) {
        return this.createEffect().at(target);
    }

    public MalumParticleEffectBuilder<T> createEffect() {
        return new MalumParticleEffectBuilder(this);
    }

    public static class MalumParticleEffectBuilder<T extends NetworkedParticleEffectExtraData>
    extends NetworkedParticleEffectType.ParticleEffectBuilder<T> {
        public MalumParticleEffectBuilder(NetworkedParticleEffectType<T> type) {
            super(type);
        }

        public MalumParticleEffectBuilder<T> color(Item item) {
            if (item instanceof SpiritLike) {
                SpiritLike spirit = (SpiritLike)item;
                return this.color(spirit);
            }
            if (item instanceof ISpiritAffiliatedItem) {
                ISpiritAffiliatedItem spiritAffiliatedItem = (ISpiritAffiliatedItem)item;
                return this.color(new MalumNetworkedParticleEffectColorData(spiritAffiliatedItem.getDefiningSpiritType()));
            }
            return this;
        }

        public MalumParticleEffectBuilder<T> color(SpiritLike ... spiritTypes) {
            return this.color(new MalumNetworkedParticleEffectColorData(spiritTypes));
        }

        public MalumParticleEffectBuilder<T> at(BlockPos position) {
            return (MalumParticleEffectBuilder)super.at(position);
        }

        public MalumParticleEffectBuilder<T> at(Vec3 position) {
            return (MalumParticleEffectBuilder)super.at(position);
        }

        public MalumParticleEffectBuilder<T> at(Entity target) {
            return (MalumParticleEffectBuilder)super.at(target);
        }

        public MalumParticleEffectBuilder<T> at(NetworkedParticleEffectPositionData position) {
            return (MalumParticleEffectBuilder)super.at(position);
        }

        public MalumParticleEffectBuilder<T> color(Color color) {
            return this.color((ColorParticleDataWrapper)ColorParticleData.create((Color)color).build());
        }

        public MalumParticleEffectBuilder<T> color(ColorParticleDataWrapper color) {
            return this.color(MalumNetworkedParticleEffectColorData.fromColor(color));
        }

        public MalumParticleEffectBuilder<T> color(List<? extends ColorParticleDataWrapper> colors) {
            return this.color(MalumNetworkedParticleEffectColorData.fromColors(colors));
        }

        public MalumParticleEffectBuilder<T> color(NetworkedParticleEffectColorData color) {
            return (MalumParticleEffectBuilder)super.color(color);
        }

        public MalumParticleEffectBuilder<T> customData(T extra) {
            return (MalumParticleEffectBuilder)super.customData(extra);
        }

        public MalumParticleEffectBuilder<T> spawn(ServerLevel level) {
            return (MalumParticleEffectBuilder)super.spawn(level);
        }

        public MalumParticleEffectBuilder<T> spawn(Consumer<NetworkedParticleEffectPayload> sender) {
            return (MalumParticleEffectBuilder)super.spawn(sender);
        }
    }
}

