/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonCoreBlockEntity;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.spirit_repair.SpiritRepairRecipe;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;

public class RepairPylonParticleEffects {
    public static SpiritLike getCentralSpiritType(RepairPylonCoreBlockEntity pylon) {
        LodestoneBlockEntityInventory spiritInventory = pylon.spiritInventory;
        int spiritCount = spiritInventory.getFilledSlotCount();
        Item currentItem = spiritInventory.getStackInSlot(0).getItem();
        if (spiritCount > 1) {
            float duration = 60.0f * (float)spiritCount;
            float gameTime = (float)pylon.getLevel().getGameTime() % duration / 60.0f;
            currentItem = spiritInventory.getStackInSlot(Mth.floor((float)gameTime)).getItem();
        }
        if (!(currentItem instanceof SpiritShardItem)) {
            return null;
        }
        SpiritShardItem spiritItem = (SpiritShardItem)currentItem;
        return spiritItem;
    }

    public static void passiveRepairPylonParticles(RepairPylonCoreBlockEntity pylon, @Nullable IMalumSpecialItemAccessPoint holder) {
        SpiritLike activeSpiritType = RepairPylonParticleEffects.getCentralSpiritType(pylon);
        if (activeSpiritType == null) {
            return;
        }
        Level level = pylon.getLevel();
        RandomSource random = level.random;
        Vec3 itemPos = pylon.getItemPos();
        SpiritRepairRecipe recipe = pylon.recipe;
        boolean isCharging = pylon.state.equals((Object)RepairPylonCoreBlockEntity.RepairPylonState.CHARGING);
        if (recipe != null) {
            SpiritLightSpecs.rotatingLightSpecs(level, itemPos, activeSpiritType, 0.5f, 3, b -> b.multiplyLifetime(1.2f).modifyScaleData(d -> d.multiplyValue(1.2f)));
            if (isCharging && holder != null) {
                Vec3 targetItemPos = holder.getItemPos();
                SpiritLightSpecs.rotatingLightSpecs(level, targetItemPos, activeSpiritType, 0.5f, 4, b -> b.multiplyLifetime(0.6f).modifyScaleData(d -> d.multiplyValue(0.95f)));
                SpiritLightSpecs.rotatingLightSpecs(level, targetItemPos, activeSpiritType, 0.75f, 5, b -> b.multiplyLifetime(1.2f).modifyScaleData(d -> d.multiplyValue(1.15f)));
            }
        }
        LodestoneBlockEntityInventory spiritInventory = pylon.spiritInventory;
        int spiritsRendered = 0;
        for (int i = 0; i < spiritInventory.slotCount; ++i) {
            ItemStack item = spiritInventory.getStackInSlot(i);
            Item item2 = item.getItem();
            if (!(item2 instanceof SpiritShardItem)) continue;
            SpiritShardItem spiritSplinterItem = (SpiritShardItem)item2;
            Vec3 offset = pylon.getSpiritItemOffset(spiritsRendered++, 0.0f);
            activeSpiritType = spiritSplinterItem;
            BlockPos blockPos = pylon.getBlockPos();
            Vec3 spiritPosition = new Vec3((double)blockPos.getX() + offset.x, (double)blockPos.getY() + offset.y, (double)blockPos.getZ() + offset.z);
            SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, activeSpiritType).spawnParticles();
            if (recipe == null || !isCharging) continue;
            Vec3 velocity = itemPos.subtract(spiritPosition).normalize().scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.03f, (float)0.06f));
            if (random.nextFloat() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, spiritPosition, activeSpiritType);
                sparkParticles.getBuilder().setMotion(velocity).modifyScaleData(d -> d.multiplyValue(1.2f));
                sparkParticles.getBloomBuilder().setMotion(velocity);
                sparkParticles.spawnParticles();
            }
            if (!(random.nextFloat() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, activeSpiritType);
            lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(velocity.scale(1.5)).modifyScaleData(d -> d.multiplyValue(1.6f));
            lightSpecs.getBloomBuilder().setMotion(velocity);
            lightSpecs.spawnParticles();
        }
    }

    public static void prepareRepairParticles(RepairPylonCoreBlockEntity pylon, IMalumSpecialItemAccessPoint holder, MalumNetworkedParticleEffectColorData colorData) {
        int i;
        SpiritLike activeSpiritType = RepairPylonParticleEffects.getCentralSpiritType(pylon);
        if (activeSpiritType == null) {
            return;
        }
        Level level = pylon.getLevel();
        RandomSource random = level.random;
        long gameTime = level.getGameTime();
        Vec3 pylonItemPos = pylon.getItemPos();
        Vec3 holderItemPos = holder.getItemPos();
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, pylonItemPos, activeSpiritType);
        }
        for (i = 0; i < 4; ++i) {
            long time;
            float distance;
            int j;
            SpiritArcanaType cyclingSpiritType = colorData.getSpirit();
            for (j = 0; j < 60; ++j) {
                distance = 0.8f * (1.0f - (float)j / 90.0f);
                time = gameTime + (long)(j * 4);
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)holderItemPos, (float)distance, (float)i, (float)4.0f, (float)time, (float)160.0f);
                if (random.nextFloat() < 0.85f) {
                    ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, offsetPosition, cyclingSpiritType);
                    sparkParticles.getBuilder().disableNoClip().setLifeDelay(j).multiplyLifetime(0.75f).modifyScaleData(d -> d.multiplyValue(1.0f));
                    sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(j).multiplyLifetime(0.75f).modifyTransparencyData(d -> d.multiplyValue(1.25f));
                    sparkParticles.spawnParticles();
                }
                if (!(random.nextFloat() < 0.85f)) continue;
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, cyclingSpiritType);
                lightSpecs.getBuilder().disableNoClip().setLifeDelay(j).modifyScaleData(d -> d.multiplyValue(1.5f));
                lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(j).modifyTransparencyData(d -> d.multiplyValue(1.25f));
                lightSpecs.spawnParticles();
            }
            for (j = 0; j < 32; ++j) {
                distance = 0.8f * ((float)j / 32.0f);
                time = gameTime + (long)(j * 3);
                int lifeDelay = 32 - j;
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)pylonItemPos, (float)distance, (float)i, (float)4.0f, (float)time, (float)160.0f);
                if (random.nextFloat() < 0.85f) {
                    ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, offsetPosition, cyclingSpiritType);
                    sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(0.75f).modifyScaleData(d -> d.multiplyValue(1.0f));
                    sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(0.75f).modifyTransparencyData(d -> d.multiplyValue(1.25f));
                    sparkParticles.spawnParticles();
                }
                if (!(random.nextFloat() < 0.85f)) continue;
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, cyclingSpiritType);
                lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).modifyScaleData(d -> d.multiplyValue(1.5f));
                lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).modifyTransparencyData(d -> d.multiplyValue(1.25f));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void repairItemParticles(RepairPylonCoreBlockEntity pylon, IMalumSpecialItemAccessPoint holder, MalumNetworkedParticleEffectColorData colorData) {
        SpiritLike activeSpiritType = RepairPylonParticleEffects.getCentralSpiritType(pylon);
        if (activeSpiritType == null) {
            return;
        }
        Level level = pylon.getLevel();
        RepairPylonParticleEffects.repairItemParticles(level, activeSpiritType, holder.getItemPos(), colorData);
    }

    public static void repairItemParticles(Level level, SpiritLike activeSpiritType, Vec3 itemPos, MalumNetworkedParticleEffectColorData colorData) {
        int i;
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, itemPos, activeSpiritType);
        }
        for (i = 0; i < 24; ++i) {
            int lifeDelay = i / 8;
            SpiritArcanaType cyclingSpiritType = colorData.getSpirit();
            float xVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float yVelocity = RandomHelper.randomBetween((RandomSource)random, (float)0.2f, (float)0.5f);
            float zVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float gravityStrength = RandomHelper.randomBetween((RandomSource)random, (float)0.75f, (float)1.0f);
            if (random.nextFloat() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, itemPos, cyclingSpiritType);
                sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravity(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyScaleData(d -> d.multiplyValue(2.0f));
                sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravity(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyTransparencyData(d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(random.nextFloat() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, itemPos, cyclingSpiritType);
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravity(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyScaleData(d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravity(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyTransparencyData(d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 8; ++i) {
            int finalI = i;
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)itemPos, (float)0.6f, (float)i, (float)8.0f, (float)gameTime, (float)160.0f);
            Consumer<WorldParticleBuilder> behavior = b -> b.addTickActor(p -> {
                if (level.getGameTime() > gameTime + (long)(finalI * 4) && level.getGameTime() < gameTime + (long)((finalI + 4) * 4)) {
                    p.setParticleSpeed(p.getParticleSpeed().add(0.0, (double)0.015f, 0.0));
                }
            });
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, activeSpiritType);
            lightSpecs.getBuilder().act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(2.0f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).multiplyLifetime(1.5f).setLifetimeModifier(l -> l + finalI * 2);
            lightSpecs.getBloomBuilder().act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(2.0f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).multiplyLifetime(1.5f).setLifetimeModifier(l -> (int)((float)l + (float)finalI * 2.5f));
            lightSpecs.spawnParticles();
        }
    }
}

