/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.rite.effect;

import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class SpiritRiteEmpowermentEffect<T extends LivingEntity>
extends SpiritRiteEntityEffect<T> {
    protected final List<Holder<MobEffect>> effectTypes;
    protected final List<SpiritHolder<SpiritArcanaType>> spirits;

    @SafeVarargs
    public SpiritRiteEmpowermentEffect(List<Holder<MobEffect>> effectTypes, SpiritHolder<SpiritArcanaType> ... spirits) {
        this(List.of(SpiritRiteEffectTag.AURA), effectTypes, spirits);
    }

    @SafeVarargs
    public SpiritRiteEmpowermentEffect(List<SpiritRiteEffectTag> tags, List<Holder<MobEffect>> effectTypes, SpiritHolder<SpiritArcanaType> ... spirits) {
        super(tags);
        this.effectTypes = effectTypes;
        this.spirits = Arrays.asList(spirits);
    }

    @Override
    public boolean canApplyEffect(ServerLevel level, T target) {
        for (Holder<MobEffect> effectType : this.effectTypes) {
            MobEffectInstance effect = target.getEffect(effectType);
            if (effect == null || effect.getAmplifier() > 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyEffect(ServerLevel level, T target) {
        this.applyEffect(level, target, 6000, 2);
    }

    public final void applyEffect(ServerLevel level, T target, int duration, int amplifier) {
        for (Holder<MobEffect> effectType : this.effectTypes) {
            if (!target.hasEffect(effectType)) continue;
            MobEffectInstance instance = new MobEffectInstance(effectType, duration, amplifier, true, true);
            target.addEffect(instance);
        }
        this.createEffect(level, target, this.spirits);
    }

    @Override
    public Holder<SoundEvent> getImpactSound() {
        return MalumSoundEvents.SPARK_POTION_IMPACT;
    }

    @Override
    public float getImpactSoundVolume(LivingEntity target) {
        return target instanceof Player ? 1.2f : 0.6f;
    }
}

