/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.geas;

import com.mojang.serialization.Codec;
import com.sammy.malum.common.data.component.GeasDataComponent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GeasEffectType {
    public static final Codec<GeasEffectType> CODEC = MalumGeasEffectTypes.GEAS_TYPES_REGISTRY.byNameCodec();
    public final Supplier<GeasEffect> effect;
    public final List<SpiritHolder<SpiritArcanaType>> spiritTypes;
    private GeasEffect dummyEffectInstance;
    private ItemStack dummyCreativeStack;

    @SafeVarargs
    public GeasEffectType(Supplier<GeasEffect> effect, SpiritHolder<SpiritArcanaType> ... spiritTypes) {
        this(effect, List.of(spiritTypes));
    }

    public GeasEffectType(Supplier<GeasEffect> effect, List<SpiritHolder<SpiritArcanaType>> spiritTypes) {
        this.effect = effect;
        this.spiritTypes = spiritTypes;
    }

    public SpiritHolder<SpiritArcanaType> getIdentifyingSpirit() {
        return this.spiritTypes.getFirst();
    }

    public String getDetailedCons() {
        return this.getLangKey() + ".cons";
    }

    public String getDetailedPros() {
        return this.getLangKey() + ".pros";
    }

    public String getDescription() {
        return this.getLangKey() + ".tooltip";
    }

    public String getLangKey() {
        return this.getRegistryName().getNamespace() + ".gui.geas." + this.getRegistryName().getPath();
    }

    public ResourceLocation getRegistryName() {
        return MalumGeasEffectTypes.GEAS_TYPES_REGISTRY.getKey((Object)this);
    }

    public ResourceLocation getIcon() {
        return this.getRegistryName().withPath(p -> "textures/item/geas/" + p).withSuffix(".png");
    }

    public Holder<GeasEffectType> getHolder() {
        return (Holder)MalumGeasEffectTypes.GEAS_TYPES_REGISTRY.getHolder(this.getRegistryName()).orElseThrow();
    }

    public boolean is(TagKey<GeasEffectType> tag) {
        return this.getHolder().is(tag);
    }

    public ItemStack createStack(boolean isCreative) {
        ItemStack geas = new ItemStack((ItemLike)MalumItems.GEAS.get());
        geas.set(MalumDataComponents.GEAS_EFFECT, (Object)new GeasDataComponent(this, isCreative));
        return geas;
    }

    public ItemStack createDefaultStack() {
        return this.createStack(false);
    }

    public ItemStack createCreativeStack() {
        return this.createStack(true);
    }

    public GeasEffect createEffect() {
        return this.effect.get();
    }

    public GeasEffect getDefaultInstance() {
        if (this.dummyEffectInstance == null) {
            this.dummyEffectInstance = this.effect.get();
        }
        return this.dummyEffectInstance;
    }

    public ItemStack getDummyCreativeStack() {
        if (this.dummyCreativeStack == null) {
            this.dummyCreativeStack = this.createCreativeStack();
        }
        return this.dummyCreativeStack;
    }
}

