/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.artifice;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeType;
import com.sammy.malum.core.systems.artifice.ArtificeModifier;
import com.sammy.malum.core.systems.artifice.TuningBehavior;
import com.sammy.malum.core.systems.artifice.TuningModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class ArtificeAttributeValue {
    public static Codec<ArtificeAttributeValue> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)ArtificeAttributeType.CODEC.fieldOf("type").forGetter(v -> v.type), (App)Codec.FLOAT.fieldOf("value").forGetter(v -> Float.valueOf(v.value)), (App)TuningModifier.CODEC.listOf().fieldOf("tuningModifiers").forGetter(v -> v.tuningModifiers)).apply((Applicative)obj, ArtificeAttributeValue::new));
    public final ArtificeAttributeType type;
    private float value;
    private List<TuningModifier> tuningModifiers;
    private float tuningMultiplierCache = 1.0f;

    public ArtificeAttributeValue(ArtificeAttributeType type) {
        this(type, type.defaultValue);
    }

    public ArtificeAttributeValue(ArtificeAttributeType type, float value) {
        this(type, value, new ArrayList<TuningModifier>());
    }

    public ArtificeAttributeValue(ArtificeAttributeType type, float value, List<TuningModifier> tuningModifiers) {
        this.type = type;
        this.value = value;
        this.tuningModifiers = new ArrayList<TuningModifier>(tuningModifiers);
        this.updateMultiplierCache();
    }

    public float getValue(ArtificeAttributeData accelerationData) {
        float value = this.value * this.tuningMultiplierCache;
        if (this.type.canBeTuned()) {
            float bonus = 1.0f + accelerationData.chainProcessingBonus;
            if (this.type.equals(ArtificeAttributeType.CHAIN_FOCUSING_CHANCE) || this.type.tuningBehavior.equals(TuningBehavior.INVERSE)) {
                bonus = 1.0f - accelerationData.chainProcessingBonus;
            }
            value *= bonus;
        }
        if (accelerationData.sympathyBuffedCycles > 0) {
            value *= 1.0f + accelerationData.sympathyBuffStrength;
        }
        return value;
    }

    public void applyModifier(ArtificeModifier modifier) {
        this.value += modifier.value();
    }

    public void applyModifier(TuningModifier modifier) {
        this.removeModifier(modifier.id());
        this.tuningModifiers.add(modifier);
        this.updateMultiplierCache();
    }

    public void updateMultiplierCache() {
        float tuningMultiplier = 1.0f;
        for (TuningModifier tuningModifier : this.tuningModifiers) {
            tuningMultiplier *= 1.0f + tuningModifier.value();
        }
        this.tuningMultiplierCache = tuningMultiplier;
    }

    public void copyFrom(ArtificeAttributeValue other) {
        if (!other.type.equals(this.type)) {
            throw new IllegalArgumentException();
        }
        this.value = other.value;
        this.tuningModifiers = other.tuningModifiers;
        this.updateMultiplierCache();
    }

    public void removeModifier(ResourceLocation id) {
        this.tuningModifiers.removeIf(m -> m.id().equals((Object)id));
        this.updateMultiplierCache();
    }

    public void clearModifiers() {
        this.tuningModifiers.clear();
        this.updateMultiplierCache();
    }
}

