/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.spirit;

import com.sammy.malum.common.data.component.SpiritJarContentsComponent;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SpiritJarItem
extends BlockItem {
    public SpiritJarItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    @NotNull
    public String getDescriptionId(ItemStack pStack) {
        if (pStack.has(MalumDataComponents.SPIRIT_JAR_CONTENTS)) {
            return "item.malum.filled_spirit_jar";
        }
        return super.getDescriptionId(pStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        SpiritJarContentsComponent contents = (SpiritJarContentsComponent)stack.get(MalumDataComponents.SPIRIT_JAR_CONTENTS);
        if (contents != null) {
            SpiritArcanaType spirit = contents.spirit();
            int count = contents.count();
            tooltipComponents.add((Component)Component.translatable((String)"malum.spirit.description.stored_spirit").withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)spirit.getCountedKey(), (Object[])new Object[]{count}).withStyle(spirit.getStyle(false)));
        }
    }
}

