/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.staff;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.entity.bolt.DrainingBoltEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.awt.Color;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class ErosionScepterItem
extends AbstractStaffItem
implements ISpiritAffiliatedItem {
    public static final Color MALIGNANT_PURPLE = new Color(68, 11, 61);
    public static final Color MALIGNANT_BLACK = new Color(12, 4, 11);
    public static final ColorParticleData SCEPTER_COLOR_DATA = ColorParticleData.create((Color)MALIGNANT_PURPLE, (Color)MALIGNANT_BLACK).setEasing(Easing.BOUNCE_IN_OUT).setCoefficient(1.2f).build();

    public ErosionScepterItem(Tier tier, float magicDamage, float chargeRate, int chargeCapacity, LodestoneItemProperties properties) {
        super(tier, magicDamage, chargeRate, chargeCapacity, properties);
    }

    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect("erosive_spread", new Object[0])});
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect("erosive_silence", new Object[0])});
    }

    @Override
    public SpiritLike getDefiningSpiritType() {
        return MalumSpiritTypes.UMBRAL_SPIRIT;
    }

    @Override
    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (!(event.getSource().getDirectEntity() instanceof AbstractBoltProjectileEntity) && event.getSource().is(LodestoneDamageTypeTags.IS_MAGIC)) {
            DeferredHolder<MobEffect, MobEffect> silenced = MalumMobEffects.SILENCED;
            MobEffectInstance effect = target.getEffect(silenced);
            if (effect == null) {
                target.addEffect(new MobEffectInstance(silenced, 150, 0, true, true, true));
            } else {
                EntityHelper.amplifyEffect((MobEffectInstance)effect, (LivingEntity)target, (int)1, (int)19);
                EntityHelper.extendEffect((MobEffectInstance)effect, (LivingEntity)target, (int)30, (int)300);
            }
            if (!event.getSource().is(MalumTags.DamageTypeTags.IS_INVERTED_HEART)) {
                SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)MalumSoundEvents.DRAINING_MOTIF.get()), (SoundSource)attacker.getSoundSource(), (float)1.0f, (float)1.25f);
            }
        }
        super.outgoingDamageEvent(event, attacker, target, stack);
    }

    @Override
    public int getProjectileCount(Level level, LivingEntity livingEntity, float pct) {
        return pct == 1.0f ? 2 : 0;
    }

    @Override
    public void fireProjectile(LivingEntity player, ItemStack stack, Level level, InteractionHand hand, int count) {
        int spawnDelay = count * 5;
        float pitchOffset = (float)count * 1.5f;
        float velocity = 4.0f;
        float magicDamage = (float)player.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE) * 0.3f;
        Vec3 pos = this.getProjectileSpawnPos(player, hand, 0.5f, 0.5f);
        for (int i = 0; i < 4; ++i) {
            float xSpread = RandomHelper.randomBetween((RandomSource)level.random, (float)-0.125f, (float)0.125f);
            float ySpread = RandomHelper.randomBetween((RandomSource)level.random, (float)-0.025f, (float)0.025f);
            DrainingBoltEntity entity = new DrainingBoltEntity(level, pos.x, pos.y, pos.z);
            if (i > 1) {
                entity.setSilent(true);
            }
            entity.setData(player, magicDamage, spawnDelay);
            entity.setItem(stack);
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -pitchOffset, velocity, 0.0f);
            Vec3 projectileDirection = entity.getDeltaMovement();
            float yRot = (float)(Mth.atan2((double)projectileDirection.x, (double)projectileDirection.z) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.cross(projectileDirection);
            entity.setDeltaMovement(entity.getDeltaMovement().add(left.scale((double)xSpread)).add(up.scale((double)ySpread)));
            level.addFreshEntity((Entity)entity);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnChargeParticles(Level pLevel, LivingEntity pLivingEntity, Vec3 pos, ItemStack pStack, float pct) {
        RandomSource random = pLevel.random;
        WorldParticleBuilder.create(MalumParticles.DRAINING_TARGET).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)pLivingEntity.getLookAngle().normalize())).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)0.1f, (float)0.2f).setSpinOffset(RandomHelper.randomBetween((RandomSource)random, (float)-0.314f, (float)0.314f)).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.8f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setColorData((ColorParticleDataWrapper)SCEPTER_COLOR_DATA.copy().setCoefficient(2.0f).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.3f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setMotion(pLivingEntity.getLookAngle().normalize().scale((double)0.05f)).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).enableForcedSpawn().setLifeDelay(2).enableNoClip().setLifetime(5).spawn(pLevel, pos.x, pos.y, pos.z).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.4f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)SCEPTER_COLOR_DATA.invert().build()).spawn(pLevel, pos.x, pos.y, pos.z);
    }
}

