/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.scythe;

import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.MalignantCritEvent;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.handlers.ItemEventHandler;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.enchanting.LodestoneEnchantmentEffectCommonsHelper;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;

public class EdgeOfDeliveranceItem
extends MalumScytheItem {
    public EdgeOfDeliveranceItem(Tier tier, float attackDamage, float attackSpeed, LodestoneItemProperties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }

    @Override
    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.BREACH)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect("edge_of_deliverance_crit", new Object[0])});
        event.addTooltipLines(new Component[]{ComponentHelper.negativeEffect("edge_of_deliverance_unpowered_attack", new Object[0])});
    }

    @Override
    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        super.outgoingDamageEvent(event, attacker, target, stack);
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!LodestoneEnchantmentEffectCommonsHelper.isChargedAttack((LivingEntity)attacker)) {
                return;
            }
            DamageSource source = event.getSource();
            if (source.is(MalumTags.DamageTypeTags.IS_SCYTHE) || source.is(MalumDamageTypes.INVERTED_HEART_PROPAGATION)) {
                DeferredHolder<MobEffect, MobEffect> effect = MalumMobEffects.IMMINENT_DELIVERANCE;
                if (target.hasEffect(effect)) {
                    if (EdgeOfDeliveranceItem.triggerMalignantCrit(event.getContainer(), attacker, target)) {
                        WeaponParticleEffectType.WeaponParticleEffectBuilder particle = MalumParticleEffectTypes.EDGE_OF_DELIVERANCE_CRIT.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).tiedToTarget().forwardOffset(-1.8f).upwardOffset(-0.4f);
                        if (!EdgeOfDeliveranceItem.canSweep(attacker)) {
                            particle.verticalSlashRotation();
                        }
                        particle.spawn(level2);
                        target.removeEffect(effect);
                    }
                } else {
                    event.setNewDamage(event.getNewDamage() * 0.5f);
                    if (source.is(MalumTags.DamageTypeTags.IS_HIDDEN_BLADE) && attacker.getRandom().nextFloat() <= 0.5f) {
                        return;
                    }
                    target.addEffect(new MobEffectInstance(MalumMobEffects.IMMINENT_DELIVERANCE, 60));
                }
            }
        }
    }

    @Override
    public Holder<SoundEvent> getScytheSound(boolean canSweep) {
        return canSweep ? MalumSoundEvents.EDGE_OF_DELIVERANCE_SWEEP : MalumSoundEvents.EDGE_OF_DELIVERANCE_CUT;
    }

    public static boolean triggerMalignantCrit(DamageContainer damageContainer, LivingEntity attacker, LivingEntity target) {
        MalignantCritEvent.Pre event = new MalignantCritEvent.Pre(target, damageContainer);
        List eventResponders = ItemEventHandler.getEventResponders((LivingEntity)attacker);
        eventResponders.forEach(lookup -> lookup.run(IMalumEventResponder.class, (eventResponderItem, stack) -> eventResponderItem.malignantCritEvent(event, attacker)));
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        MalignantCritEvent.Post postEvent = new MalignantCritEvent.Post(target, damageContainer);
        eventResponders.forEach(lookup -> lookup.run(IMalumEventResponder.class, (eventResponderItem, stack) -> eventResponderItem.finalizedMalignantCritEvent(postEvent, attacker)));
        NeoForge.EVENT_BUS.post((Event)postEvent);
        damageContainer.setNewDamage(damageContainer.getNewDamage() * 2.0f);
        SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)MalumSoundEvents.MALIGNANT_METAL_MOTIF.get()), (SoundSource)SoundSource.PLAYERS, (float)2.0f, (float)0.75f);
        SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)MalumSoundEvents.MALIGNANT_METAL_MOTIF.get()), (SoundSource)SoundSource.PLAYERS, (float)3.0f, (float)1.25f);
        SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)MalumSoundEvents.MALIGNANT_METAL_MOTIF.get()), (SoundSource)SoundSource.PLAYERS, (float)3.0f, (float)1.75f);
        return true;
    }
}

