/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.rotten;

import com.sammy.malum.common.effect.gluttony.GluttonyEffect;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.RandomHelper;

public class CurioVoraciousRing
extends MalumCurioItem {
    public CurioVoraciousRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.ROTTEN);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("eat_rotten", new Object[0]));
        consumer.accept(ComponentHelper.positiveCurioEffect("growing_gluttony", new Object[0]));
    }

    public static void modifyEating(LivingEntityUseItemEvent.Start event) {
        if (event.getItem().is(MalumTags.ItemTags.GROSS_FOODS) && CurioHelper.hasCurioEquipped((LivingEntity)event.getEntity(), (Item)((Item)MalumItems.RING_OF_DESPERATE_VORACITY.get()))) {
            event.setDuration((int)((float)event.getDuration() * 0.5f));
        }
    }

    public static void onEat(Level level, LivingEntity livingEntity, ItemStack food) {
        if (level.isClientSide) {
            return;
        }
        if (food.is(MalumTags.ItemTags.GROSS_FOODS) && CurioHelper.hasCurioEquipped((LivingEntity)livingEntity, (Item)((Item)MalumItems.RING_OF_DESPERATE_VORACITY.get()))) {
            GluttonyEffect.applyGluttony(livingEntity, b -> b.setDurationGain(300).setDurationLimit(3000));
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.getFoodData().eat(1, 1.0f);
            }
            livingEntity.playSound((SoundEvent)MalumSoundEvents.VORACIOUS_RING_FEEDS.get(), 0.5f, RandomHelper.randomBetween((RandomSource)level.random, (float)1.2f, (float)1.6f));
        }
    }
}

