/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.earthen;

import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.ModifyGluttonyPropertiesEvent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class ProfaneAsceticGeas
extends GeasEffect {
    public ProfaneAsceticGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_PROFANE_ASCETIC.get());
    }

    @Override
    public void modifyGluttonyPropertiesEvent(ModifyGluttonyPropertiesEvent event, LivingEntity collector) {
        event.getProperties().scaleInitialDuration(2.0f).scaleDurationLimit(4.0f).scaleDurationGain(2.0f).scaleAmplifierLimit(2.0f).replaceEffectType((Holder<MobEffect>)MalumMobEffects.TRIAL_OF_FAITH);
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("trial_of_faith", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("trial_of_faith_healing", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("rotten_healing", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("no_passive_healing", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("no_normal_foods", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    public static boolean isProfaneAscetic(LivingEntity entity) {
        return GeasEffectHandler.hasGeasEffect(entity, MalumGeasEffectTypes.PACT_OF_THE_PROFANE_ASCETIC);
    }

    public static void modifyEating(LivingEntityUseItemEvent.Start event) {
        if (ProfaneAsceticGeas.isProfaneAscetic(event.getEntity()) && event.getItem().getFoodProperties(event.getEntity()) != null) {
            float multiplier = event.getItem().is(MalumTags.ItemTags.GROSS_FOODS) ? 0.66f : 2.0f;
            event.setDuration((int)((float)event.getDuration() * multiplier));
        }
    }

    public static void onEat(Level level, LivingEntity livingEntity, ItemStack food) {
        if (level.isClientSide) {
            return;
        }
        if (ProfaneAsceticGeas.isProfaneAscetic(livingEntity)) {
            if (food.is(MalumTags.ItemTags.GROSS_FOODS)) {
                livingEntity.heal(livingEntity.getMaxHealth() / 5.0f);
            } else {
                livingEntity.hurt(DamageTypeHelper.create((Level)level, MalumDamageTypes.KARMIC), livingEntity.getMaxHealth() / 2.0f);
            }
        }
    }
}

