/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.effect.geas;

import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class AvariceEffect
extends MobEffect {
    public AvariceEffect() {
        super(MobEffectCategory.BENEFICIAL, ColorHelper.getColor((int)255, (int)230, (int)93));
    }

    public static int addFortune(LivingEntity entity, @Nullable Vec3 position, int enchantmentLevel) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return 0;
        }
        ServerLevel level2 = (ServerLevel)level;
        DeferredHolder<MobEffect, MobEffect> effect = MalumMobEffects.AVARICE;
        MobEffectInstance instance = entity.getEffect(effect);
        if (instance != null) {
            int bonus = 0;
            RandomSource rand = entity.level().getRandom();
            for (float chance = 0.1f * (float)(instance.getAmplifier() + 1); chance > 0.0f; chance -= 1.0f) {
                if (!(chance >= 1.0f) && !(rand.nextFloat() < chance)) continue;
                ++bonus;
            }
            if (bonus > 0) {
                if (enchantmentLevel < 3) {
                    bonus += 3 - enchantmentLevel;
                }
                if (position != null) {
                    MalumParticleEffectTypes.AVARICE_FORTUNE_EFFECT.createEffect(position).color(MalumSpiritTypes.INFERNAL_SPIRIT).spawn(level2);
                }
                SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)MalumSoundEvents.AVARICE_FORTUNE.get()), (float)1.0f, (float)(0.8f + entity.getRandom().nextFloat() * 0.4f));
            }
            return bonus;
        }
        return 0;
    }
}

