/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.the_device;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.ProgressionData;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class TheDevice
extends Block {
    private final int funnyComparatorNumber = MalumMod.RANDOM.nextInt(16);

    public TheDevice(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult hit) {
        if (pHand.equals((Object)InteractionHand.MAIN_HAND)) {
            pPlayer.swing(pHand, true);
            this.playSound(pLevel, pPos);
            if (pPlayer.isCreative()) {
                ProgressionData data = (ProgressionData)pPlayer.getData(MalumAttachmentTypes.PROGRESSION_DATA);
                data.hasBeenRejected = false;
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, hit);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return this.funnyComparatorNumber;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean flag = pLevel.hasNeighborSignal(pPos);
        if (flag) {
            this.playSound(pLevel, pPos);
        }
    }

    public void playSound(Level level, BlockPos pos) {
        level.playSound(null, pos, (SoundEvent)MalumSoundEvents.THE_DEEP_BECKONS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

