/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.storage.stand;

import com.sammy.malum.common.block.storage.stand.ItemStandBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import team.lodestar.lodestone.systems.block.WaterLoggedEntityBlock;

public class ItemStandBlock<T extends ItemStandBlockEntity>
extends WaterLoggedEntityBlock<T> {
    public static final VoxelShape UP = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    public static final VoxelShape DOWN = Block.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape SOUTH = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0);
    public static final VoxelShape NORTH = Block.box((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0);
    public static final VoxelShape WEST = Block.box((double)14.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    public static final VoxelShape EAST = Block.box((double)0.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0);

    public ItemStandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH));
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof ItemStandBlockEntity) {
            ItemStandBlockEntity stand = (ItemStandBlockEntity)be;
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)stand.getInventory(Direction.UP));
        }
        return 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
            case SOUTH: {
                return SOUTH;
            }
            case NORTH: {
                return NORTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: {
                return EAST;
            }
        }
        return super.getShape(state, level, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_152803_) {
        return (BlockState)super.getStateForPlacement(p_152803_).setValue((Property)BlockStateProperties.FACING, (Comparable)p_152803_.getClickedFace());
    }
}

