/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.nature.soulwood;

import com.sammy.malum.common.block.nature.MalumSaplingBlock;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class SoulwoodGrowthBlock
extends MalumSaplingBlock {
    public SoulwoodGrowthBlock(TreeGrower treeGrower, BlockBehaviour.Properties properties) {
        super(treeGrower, properties);
    }

    protected boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        if (pState.is(MalumTags.BlockTags.BLIGHT_PLACEABLE_ON)) {
            return true;
        }
        return super.mayPlaceOn(pState, pLevel, pPos);
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRand, BlockPos pPos, BlockState pState) {
        super.performBonemeal(pLevel, pRand, pPos, pState);
        pLevel.levelEvent(1505, pPos, 0);
        pLevel.playSound(null, pPos, (SoundEvent)MalumSoundEvents.MINOR_BLIGHT_MOTIF.get(), SoundSource.BLOCKS, 1.0f, 0.9f + pLevel.random.nextFloat() * 0.25f);
        pLevel.playSound(null, pPos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 0.9f + pLevel.random.nextFloat() * 0.25f);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemInHand, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand hand, BlockHitResult hitResult) {
        if (itemInHand.getItem() instanceof SpiritShardItem) {
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                this.performBonemeal(serverLevel, pLevel.random, pPos, pState);
            }
            if (!pPlayer.isCreative()) {
                itemInHand.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemInHand, pState, pLevel, pPos, pPlayer, hand, hitResult);
    }
}

