/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem.anchor;

import com.sammy.malum.common.block.curiosities.totem.anchor.RiteAnchorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.block.LodestoneEntityBlock;

public class RiteAnchorBlock
extends LodestoneEntityBlock<RiteAnchorBlockEntity> {
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public RiteAnchorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, SOUTH, EAST, WEST, POWERED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            Direction direction = Direction.from2DDataValue((int)i);
            BooleanProperty property = this.getDirectionProperty(direction);
            BlockPos pos = context.getClickedPos();
            boolean value = Block.shouldRenderFace((BlockState)state, (BlockGetter)context.getLevel(), (BlockPos)pos, (Direction)direction, (BlockPos)pos.relative(direction));
            state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(!value));
        }
        return state;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        Direction direction = Direction.fromDelta((int)(fromPos.getX() - pos.getX()), (int)(fromPos.getY() - pos.getY()), (int)(fromPos.getZ() - pos.getZ()));
        if (direction != null && direction.getAxis().isHorizontal()) {
            BooleanProperty property = this.getDirectionProperty(direction);
            boolean value = Block.shouldRenderFace((BlockState)state, (BlockGetter)level, (BlockPos)pos, (Direction)direction, (BlockPos)pos.relative(direction));
            level.setBlock(pos, (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(!value)), 2);
        }
        if (!level.isClientSide && (flag = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != level.hasNeighborSignal(pos)) {
            if (flag) {
                level.scheduleTick(pos, (Block)this, 4);
            } else {
                level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public BooleanProperty getDirectionProperty(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(direction));
        };
    }

    public static boolean isOccluded(BlockState state, Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> (Boolean)state.getValue((Property)NORTH);
            case Direction.SOUTH -> (Boolean)state.getValue((Property)SOUTH);
            case Direction.EAST -> (Boolean)state.getValue((Property)EAST);
            case Direction.WEST -> (Boolean)state.getValue((Property)WEST);
            default -> false;
        };
    }
}

